/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.model.Condition;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.condition.ConditionEvaluatorStrategy;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class DefaultConditionEvaluator
implements ConditionEvaluator {
    private final Map<String, ConditionEvaluatorStrategy> allStrategy = new HashMap<String, ConditionEvaluatorStrategy>();

    public boolean evaluate(Condition condition, RuleData context) {
        if (condition == null || StringUtils.isEmpty((Object)condition)) {
            return true;
        }
        return Optional.ofNullable(this.allStrategy.get(condition.getType())).map(strategy -> strategy.evaluate(condition, context)).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6761\u4ef6\u7c7b\u578b:" + condition.getType()));
    }

    public Function<RuleData, Mono<Boolean>> prepare(Condition condition) {
        if (condition == null || StringUtils.isEmpty((Object)condition.getConfiguration())) {
            return ignore -> Reactors.ALWAYS_TRUE;
        }
        return Optional.ofNullable(this.allStrategy.get(condition.getType())).map(strategy -> strategy.prepare(condition)).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6761\u4ef6\u7c7b\u578b:" + condition.getType()));
    }

    public void register(ConditionEvaluatorStrategy strategy) {
        this.allStrategy.put(strategy.getType(), strategy);
    }
}

