/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.rule.engine.api.model.RuleEngineModelParser;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.model.RuleModelParserStrategy;

public class DefaultRuleModelParser
implements RuleEngineModelParser {
    private final Map<String, RuleModelParserStrategy> allStrategy = new ConcurrentHashMap<String, RuleModelParserStrategy>();

    public List<String> getAllSupportFormat() {
        return new ArrayList<String>(this.allStrategy.keySet());
    }

    public RuleModel parse(String format, String modelDefineString) {
        return Optional.ofNullable(this.allStrategy.get(format)).map(strategy -> {
            RuleModel model = strategy.parse(modelDefineString);
            model.setType(format);
            return model;
        }).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6a21\u578b\u683c\u5f0f:" + format));
    }

    public void register(RuleModelParserStrategy strategy) {
        this.allStrategy.put(strategy.getFormat(), strategy);
    }
}

