/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.exception.I18nSupportException;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.model.Condition;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.condition.ConditionEvaluatorStrategy;
import reactor.core.publisher.Mono;

public class DefaultConditionEvaluator
implements ConditionEvaluator {
    private final Map<String, ConditionEvaluatorStrategy> allStrategy = new HashMap<String, ConditionEvaluatorStrategy>();

    public boolean evaluate(Condition condition, RuleData context) {
        if (condition == null || MapUtils.isEmpty((Map)condition.getConfiguration())) {
            return true;
        }
        return Optional.ofNullable(this.allStrategy.get(condition.getType())).map(strategy -> strategy.evaluate(condition, context)).orElseThrow(() -> new I18nSupportException.NoStackTrace("error.rule.unsupported_condition_type", new Object[]{condition.getType()}));
    }

    public Function<RuleData, Mono<Boolean>> prepare(Condition condition) {
        if (condition == null || MapUtils.isEmpty((Map)condition.getConfiguration())) {
            return ignore -> Reactors.ALWAYS_TRUE;
        }
        return Optional.ofNullable(this.allStrategy.get(condition.getType())).map(strategy -> strategy.prepare(condition)).orElseThrow(() -> new I18nSupportException.NoStackTrace("error.rule.unsupported_condition_type", new Object[]{condition.getType()}));
    }

    public void register(ConditionEvaluatorStrategy strategy) {
        this.allStrategy.put(strategy.getType(), strategy);
    }
}

