/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.model.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.rule.engine.api.model.Condition;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.jetlinks.rule.engine.api.scheduler.SchedulingRule;
import org.jetlinks.rule.engine.model.RuleModelParserStrategy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class XmlRuleModelParserStrategy
implements RuleModelParserStrategy {
    @Override
    public String getFormat() {
        return "re.xml";
    }

    @Override
    public RuleModel parse(String modelDefineString) {
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(modelDefineString));
        ArrayList<PrepareRuleNode> prepareRuleNodeList = new ArrayList<PrepareRuleNode>();
        Element rule = document.getRootElement();
        RuleModel ruleModel = new RuleModel();
        ruleModel.setId(rule.attributeValue("id"));
        ruleModel.setName(rule.attributeValue("name"));
        ruleModel.setDescription(rule.attributeValue("description"));
        ruleModel.setConfiguration(new HashMap());
        this.parseConfig(rule.element("configuration"), ruleModel.getConfiguration());
        Iterator it = rule.elementIterator("node");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            prepareRuleNodeList.add(this.parseNode(element));
        }
        Map nodes = prepareRuleNodeList.stream().map(PrepareRuleNode::toRuleNodeModel).collect(Collectors.toMap(RuleNodeModel::getId, Function.identity()));
        for (PrepareRuleNode node : prepareRuleNodeList) {
            RuleLink link;
            RuleNodeModel outputNode;
            if (StringUtils.isEmpty((Object)node.getId())) {
                throw new NullPointerException("\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            RuleNodeModel model = (RuleNodeModel)nodes.get(node.getId());
            model.setRuleId(ruleModel.getId());
            for (PrepareLink output : node.outputs) {
                outputNode = (RuleNodeModel)nodes.get(output.target);
                if (null == outputNode) continue;
                link = new RuleLink();
                if (StringUtils.hasText((String)output.id)) {
                    link.setId(output.id);
                } else {
                    link.setId(model.getId() + "-link-" + outputNode.getId());
                }
                link.setType(output.type);
                link.setCondition(output.condition);
                link.setTarget(outputNode);
                link.setSource(model);
                link.setConfiguration(output.configuration);
                outputNode.getInputs().add(link);
                model.getOutputs().add(link);
            }
            for (PrepareLink event : node.events) {
                outputNode = (RuleNodeModel)nodes.get(event.target);
                if (null == outputNode) continue;
                link = new RuleLink();
                if (StringUtils.hasText((String)event.id)) {
                    link.setId(event.id);
                } else {
                    link.setId(model.getId() + "-link-" + outputNode.getId());
                }
                link.setType(event.type);
                link.setCondition(event.condition);
                link.setTarget(outputNode);
                link.setSource(model);
                model.getEvents().add(link);
                outputNode.getInputs().add(link);
            }
        }
        ruleModel.getNodes().addAll(nodes.values());
        return ruleModel;
    }

    private PrepareRuleNode parseNode(Element element) {
        PrepareRuleNode node = new PrepareRuleNode();
        node.nodeProperties = element.attributes().stream().collect(Collectors.toMap(Node::getName, Attribute::getValue));
        Element schedulingRule = element.element("scheduling-rule");
        if (null != schedulingRule) {
            SchedulingRule rule = new SchedulingRule();
            String type = schedulingRule.attributeValue("type");
            rule.setType(type);
            HashMap config = new HashMap();
            schedulingRule.elements().forEach(ele -> this.parseConfig((Element)ele, config));
            rule.setConfiguration(config);
            node.nodeProperties.put("schedulingRule", schedulingRule);
        }
        this.parseConfig(element.element("configuration"), node.configuration);
        Optional.ofNullable(element.element("outputs")).map(e -> e.elements("output")).ifPresent(lst -> node.outputs.addAll(lst.stream().map(this::parseLink).collect(Collectors.toList())));
        Optional.ofNullable(element.element("events")).map(e -> e.elements("event")).ifPresent(lst -> node.events.addAll(lst.stream().map(this::parseLink).collect(Collectors.toList())));
        return node;
    }

    private void parseConfig(Element element, Map<String, Object> map) {
        if (element == null) {
            return;
        }
        for (Element ele : element.elements()) {
            HashMap<String, Object> value;
            List elements = ele.elements();
            String key = ele.getName();
            String type = ele.attributeValue("type");
            if (!CollectionUtils.isEmpty((Collection)elements)) {
                if ("list".equals(type)) {
                    ArrayList<Object> data = new ArrayList<Object>();
                    for (Element child : elements) {
                        String text = child.getTextTrim();
                        if (StringUtils.hasLength((String)text)) {
                            data.add(text);
                            continue;
                        }
                        HashMap<String, Object> val = new HashMap<String, Object>();
                        this.parseConfig(child, val);
                        data.add(val);
                    }
                    value = data;
                } else {
                    HashMap<String, Object> val = new HashMap<String, Object>();
                    for (Element child : elements) {
                        if (CollectionUtils.isEmpty((Collection)child.elements())) {
                            val.put(child.getName(), child.getTextTrim());
                            continue;
                        }
                        HashMap<String, Object> childMap = new HashMap<String, Object>();
                        this.parseConfig(child, childMap);
                        val.put(child.getName(), childMap);
                    }
                    value = val;
                }
            } else {
                value = ele.getTextTrim();
            }
            map.put(key, value);
        }
    }

    private PrepareLink parseLink(Element element) {
        PrepareLink link = new PrepareLink();
        link.configuration = element.elements().stream().collect(Collectors.toMap(Node::getName, Element::getTextTrim));
        link.id = element.attributeValue("id");
        link.target = element.attributeValue("target");
        link.type = element.attributeValue("type");
        Element conditionEl = element.element("condition");
        if (conditionEl != null) {
            Element configuration = element.element("condition");
            link.condition = new Condition();
            link.condition.setType(conditionEl.attributeValue("type"));
            if (null != configuration) {
                link.condition.setConfiguration(configuration.elements().stream().collect(Collectors.toMap(Node::getName, Element::getTextTrim)));
            }
        }
        return link;
    }

    private static class PrepareRuleNode {
        private Map<String, Object> nodeProperties = new HashMap<String, Object>();
        private final Map<String, Object> configuration = new HashMap<String, Object>();
        private final List<PrepareLink> outputs = new ArrayList<PrepareLink>();
        private final List<PrepareLink> events = new ArrayList<PrepareLink>();

        private PrepareRuleNode() {
        }

        private String getId() {
            return (String)this.nodeProperties.get("id");
        }

        public RuleNodeModel toRuleNodeModel() {
            RuleNodeModel ruleNodeModel = (RuleNodeModel)FastBeanCopier.copy(this.nodeProperties, (Object)new RuleNodeModel(), (String[])new String[0]);
            ruleNodeModel.setConfiguration(this.configuration);
            return ruleNodeModel;
        }
    }

    private static class PrepareLink {
        private String id;
        private String type;
        private Map<String, Object> configuration = new HashMap<String, Object>();
        private String target;
        private Condition condition;

        private PrepareLink() {
        }
    }
}

