/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device;

import com.alibaba.fastjson.JSONObject;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.device.DeviceState;

public class DeviceInfo
implements Externalizable,
Jsonable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String productId;
    private String productName;
    private String photoUrl;
    private Map<String, Object> configuration;
    private String creatorId;
    private Long createTime;
    private DeviceState state;

    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        if (this.state != null) {
            jsonObject.put("state", (Object)this.state.name());
        }
        return jsonObject;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeNullableUTF((String)this.id, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.name, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.productId, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.productName, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.photoUrl, (ObjectOutput)out);
        SerializeUtils.writeKeyValue(this.configuration, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.creatorId, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.createTime, (ObjectOutput)out);
        out.writeByte(this.state == null ? -1 : this.state.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.name = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.productId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.productName = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.photoUrl = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.configuration = SerializeUtils.readMap((ObjectInput)in, LinkedHashMap::new);
        this.creatorId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.createTime = (Long)SerializeUtils.readObject((ObjectInput)in);
        byte state = in.readByte();
        if (state >= 0) {
            this.state = DeviceState.values()[state];
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public DeviceState getState() {
        return this.state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }
}

