/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai;

import java.io.Externalizable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.HeaderSupport;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.sdk.server.file.FileData;

public interface AiOutput<Self extends AiOutput<Self>>
extends HeaderSupport<Self>,
Externalizable,
Jsonable {
    public String getSourceId();

    public String getId();

    public boolean isSuccess();

    public String getErrorCode();

    public String getErrorMessage();

    public long getTimestamp();

    default public List<? extends FileData> files() {
        return Collections.emptyList();
    }

    default public Map<String, Object> toLightWeighMap() {
        return (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]);
    }

    default public List<Map<String, Object>> flat() {
        return Collections.singletonList(this.toLightWeighMap());
    }

    default public List<Map<String, Object>> lightWeighFlat() {
        return this.flat();
    }

    default public void release() {
        List<FileData> files = this.files();
        if (files != null) {
            for (FileData file : files) {
                file.release();
            }
        }
    }
}

