/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.sdk.server.ai.AICommandHandler;
import org.springframework.util.StringUtils;

public class AiOutputMetadataBuilder {
    @Schema(description="\u5e73\u94fa(List<Map>\u7c7b\u578b\u7684)\u5c5e\u6027\uff0c\u5c06\u96c6\u5408\u5185\u7ed3\u6784\u4f53\u5e73\u94fa\u81f3\u5916\u5c42")
    private String flatProperty;
    @Schema(description="\u5e73\u94fa\u65f6\u662f\u5426\u4fdd\u7559\u5916\u5c42\u5c5e\u6027")
    private boolean keepProperties;
    @Schema(description="\u4fdd\u7559\u5c5e\u6027\uff08\u4e0e\u79fb\u9664\u5c5e\u6027\u4e0d\u5171\u5b58\uff09")
    private Set<String> includes;
    @Schema(description="\u79fb\u9664\u5c5e\u6027\uff08\u4e0e\u4fdd\u7559\u5c5e\u6027\u4e0d\u5171\u5b58\uff09\uff0c\u652f\u6301{key}.{key}\u683c\u5f0f\u79fb\u9664\u7ed3\u6784\u4f53\u5185\u90e8\u5c5e\u6027")
    private Set<String> excludes;

    public <T extends Command<?>> Collection<PropertyMetadata> generateMetadata(Class<T> aclass) {
        List<PropertyMetadata> src = AICommandHandler.getCommandOutputMetadata(aclass);
        return this.generateMetadata(src);
    }

    public Collection<PropertyMetadata> generateMetadata(Collection<PropertyMetadata> src) {
        HashMap<Object, Object> resMap = new HashMap();
        Map<String, PropertyMetadata> srcMap = src.stream().collect(Collectors.toMap(Metadata::getId, Function.identity()));
        List<PropertyMetadata> flat = null;
        if (StringUtils.hasText((String)this.flatProperty)) {
            flat = this.generateFlat(srcMap);
            if (!this.keepProperties) {
                return flat;
            }
            this.addExclude(this.flatProperty);
        }
        if (CollectionUtils.isNotEmpty(this.includes)) {
            for (String include : this.includes) {
                PropertyMetadata propertyMetadata = srcMap.get(include);
                if (propertyMetadata == null) continue;
                resMap.put(include, propertyMetadata);
            }
        } else if (CollectionUtils.isNotEmpty(this.excludes)) {
            resMap = new HashMap<String, PropertyMetadata>(srcMap);
            for (String exclude : this.excludes) {
                if (exclude.contains(".")) {
                    String[] split = exclude.split("\\.");
                    String base = split[0];
                    PropertyMetadata property = (PropertyMetadata)resMap.get(base);
                    if (property == null) continue;
                    PropertyMetadata _property = AiOutputMetadataBuilder.exclude(split.length - 1, split, property);
                    resMap.put(base, _property);
                    continue;
                }
                resMap.remove(exclude);
            }
        }
        Collection<PropertyMetadata> res = resMap.values();
        if (flat != null) {
            res = new ArrayList<PropertyMetadata>(res);
            res.addAll(flat);
        }
        return res;
    }

    private static PropertyMetadata exclude(int index, String[] split, PropertyMetadata property) {
        if (property == null) {
            return null;
        }
        int _index = index - 1;
        String id = split[split.length - index];
        DataType dataType = property.getValueType();
        if ("object".equals(dataType.getId())) {
            ObjectType object = (ObjectType)dataType;
            List properties = object.getProperties();
            Map propertiesMap = properties.stream().collect(Collectors.toMap(Metadata::getId, Function.identity()));
            if (_index == 0) {
                propertiesMap.remove(id);
                ObjectType copy = (ObjectType)FastBeanCopier.copy((Object)object, (Object)new ObjectType(), (String[])new String[]{"properties"});
                copy.setProperties(new ArrayList(propertiesMap.values()));
                return SimplePropertyMetadata.of((DataType)copy, (String)property.getId(), (String)property.getName(), (String)property.getDescription(), (Map)property.getExpands());
            }
            PropertyMetadata metadata = AiOutputMetadataBuilder.exclude(_index, split, (PropertyMetadata)propertiesMap.get(id));
            if (metadata != null) {
                propertiesMap.put(id, metadata);
                ObjectType copy = (ObjectType)FastBeanCopier.copy((Object)object, (Object)new ObjectType(), (String[])new String[]{"properties"});
                copy.setProperties(new ArrayList(propertiesMap.values()));
                return SimplePropertyMetadata.of((DataType)copy, (String)property.getId(), (String)property.getName(), (String)property.getDescription(), (Map)property.getExpands());
            }
        }
        return property;
    }

    private List<PropertyMetadata> generateFlat(Map<String, PropertyMetadata> srcMap) {
        ArrayType array;
        DataType elementType;
        PropertyMetadata flat = srcMap.get(this.flatProperty);
        DataType dataType = flat.getValueType();
        if ("array".equals(dataType.getType()) && "object".equals((elementType = (array = (ArrayType)dataType).getElementType()).getId())) {
            ObjectType object = (ObjectType)elementType;
            return object.getProperties();
        }
        return Collections.emptyList();
    }

    private void addExclude(String ... excludes) {
        if (this.excludes == null) {
            this.excludes = new HashSet<String>();
        }
        this.excludes.addAll(Arrays.asList(excludes));
    }

    private static boolean $default$keepProperties() {
        return true;
    }

    AiOutputMetadataBuilder(String flatProperty, boolean keepProperties, Set<String> includes, Set<String> excludes) {
        this.flatProperty = flatProperty;
        this.keepProperties = keepProperties;
        this.includes = includes;
        this.excludes = excludes;
    }

    public static AiOutputMetadataBuilderBuilder builder() {
        return new AiOutputMetadataBuilderBuilder();
    }

    public static class AiOutputMetadataBuilderBuilder {
        private String flatProperty;
        private boolean keepProperties$set;
        private boolean keepProperties$value;
        private Set<String> includes;
        private Set<String> excludes;

        AiOutputMetadataBuilderBuilder() {
        }

        public AiOutputMetadataBuilderBuilder flatProperty(String flatProperty) {
            this.flatProperty = flatProperty;
            return this;
        }

        public AiOutputMetadataBuilderBuilder keepProperties(boolean keepProperties) {
            this.keepProperties$value = keepProperties;
            this.keepProperties$set = true;
            return this;
        }

        public AiOutputMetadataBuilderBuilder includes(Set<String> includes) {
            this.includes = includes;
            return this;
        }

        public AiOutputMetadataBuilderBuilder excludes(Set<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public AiOutputMetadataBuilder build() {
            boolean keepProperties$value = this.keepProperties$value;
            if (!this.keepProperties$set) {
                keepProperties$value = AiOutputMetadataBuilder.$default$keepProperties();
            }
            return new AiOutputMetadataBuilder(this.flatProperty, keepProperties$value, this.includes, this.excludes);
        }

        public String toString() {
            return "AiOutputMetadataBuilder.AiOutputMetadataBuilderBuilder(flatProperty=" + this.flatProperty + ", keepProperties$value=" + this.keepProperties$value + ", includes=" + this.includes + ", excludes=" + this.excludes + ")";
        }
    }
}

