/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.commons.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetlinks.core.command.AbstractConvertCommand;
import org.jetlinks.core.command.GenericInputCommand;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import reactor.core.publisher.Flux;

public abstract class BatchDataCommand<T, Self extends BatchDataCommand<T, Self>>
extends AbstractConvertCommand<Flux<T>, Self>
implements GenericInputCommand<T> {
    public static final String PARAMETER_KEY = "data";

    @SafeVarargs
    public final Self withData(T ... entityInstances) {
        return this.withData(Arrays.asList(entityInstances));
    }

    public final Self withData(List<? extends T> entityInstances) {
        this.writable().put(PARAMETER_KEY, entityInstances);
        return (Self)((Object)((BatchDataCommand)this.castSelf()));
    }

    public final <E extends T> List<E> dataList() {
        return this.dataList(v -> this.createResponseData(v));
    }

    public final <E extends T> List<E> dataList(Function<Object, E> converter) {
        return ConverterUtils.convertToList(this.readable().get(PARAMETER_KEY), converter);
    }

    protected static class InputSpec<T>
    implements GenericInputCommand.InputSpec<T> {
        @Schema(title="\u6570\u636e")
        private List<T> data;

        protected InputSpec() {
        }

        public List<T> getData() {
            return this.data;
        }

        public void setData(List<T> data) {
            this.data = data;
        }
    }
}

