/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DeviceSelector;
import reactor.core.publisher.Flux;

@Schema(title="\u53d1\u9001\u6d88\u606f\u7ed9\u8bbe\u5907")
public class DownstreamCommand<T extends DeviceMessage, R extends DeviceMessageReply>
extends AbstractCommand<Flux<R>, DownstreamCommand<T, R>> {
    public T getMessage() {
        Object msg = this.readable().get("message");
        if (msg instanceof DeviceMessage) {
            return (T)((DeviceMessage)msg);
        }
        if (msg instanceof Map) {
            return this.convertMessage((Map)msg);
        }
        return this.convertMessage(this.readable());
    }

    protected T convertMessage(Map<String, Object> message) {
        return (T)((DeviceMessage)MessageType.convertMessage(message).orElse(null));
    }

    public DownstreamCommand<T, R> withMessage(Map<String, Object> message) {
        this.writable().put("message", message);
        return (DownstreamCommand)this.castSelf();
    }

    public DownstreamCommand<T, R> withMessage(DeviceMessage message) {
        this.writable().put("message", message);
        return (DownstreamCommand)this.castSelf();
    }

    public static class Properties {
    }

    protected static class Message {
        @DeviceSelector
        @NotBlank
        @Schema(title="\u8bbe\u5907id")
        private String deviceId;
        @Schema(title="\u6d88\u606f\u5934")
        private Headers headers;

        protected Message() {
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public Headers getHeaders() {
            return this.headers;
        }
    }

    protected static class Headers {
        @Schema(title="\u6307\u5b9a\u53d1\u9001\u6d88\u606f\u7684\u8d85\u65f6\u65f6\u95f4")
        private Long timeout;
        @Schema(title="\u662f\u5426\u5f02\u6b65")
        private Boolean async;

        protected Headers() {
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public void setAsync(Boolean async) {
            this.async = async;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public Boolean getAsync() {
            return this.async;
        }
    }

    protected static class InputSpec {
        @Schema(title="\u6d88\u606f")
        private Message message;

        protected InputSpec() {
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

