/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.sdk.server.commons.AggregationRequest;
import org.jetlinks.sdk.server.commons.cmd.OperationByIdCommand;
import org.jetlinks.sdk.server.device.DevicePropertyAggregation;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DeviceSelector;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

@Schema(title="\u805a\u5408\u67e5\u8be2\u8bbe\u5907\u5c5e\u6027")
public class QueryPropertyAggCommand
extends OperationByIdCommand<Flux<Map<String, Object>>, QueryPropertyAggCommand> {
    private static final long serialVersionUID = 1L;
    static Type columnsType = ResolvableType.forClassWithGenerics(List.class, (Class[])new Class[]{DevicePropertyAggregation.class}).getType();

    @Override
    @DeviceSelector
    @NotBlank
    @Schema(name="id", title="ID")
    public String getId() {
        return super.getId();
    }

    @Schema(title="\u805a\u5408\u5b57\u6bb5")
    @NotBlank
    public List<DevicePropertyAggregation> getColumns() {
        return (List)this.getOrNull("columns", columnsType);
    }

    public QueryPropertyAggCommand withColumns(List<DevicePropertyAggregation> columns) {
        this.writable().put("columns", columns);
        return this;
    }

    @Schema(title="\u67e5\u8be2\u6761\u4ef6")
    @NotBlank
    public AggregationRequest getQuery() {
        return (AggregationRequest)this.getOrNull("query", AggregationRequest.class);
    }

    public QueryPropertyAggCommand withQuery(AggregationRequest query) {
        this.writable().put("query", query);
        return this;
    }

    public static CommandHandler<QueryPropertyAggCommand, Flux<Map<String, Object>>> createHandler(Function<QueryPropertyAggCommand, Flux<Map<String, Object>>> handler) {
        return CommandHandler.of(QueryPropertyAggCommand::metadata, (cmd, ignore) -> (Flux)handler.apply((QueryPropertyAggCommand)((Object)cmd)), QueryPropertyAggCommand::new);
    }

    public static List<PropertyMetadata> getQueryParamMetadata() {
        return Arrays.asList(SimplePropertyMetadata.of((String)"id", (String)"Id", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"columns", (String)"\u805a\u5408\u5b57\u6bb5", (DataType)new ArrayType().elementType((DataType)new ObjectType().addProperty("property", "\u5c5e\u6027ID", (DataType)StringType.GLOBAL).addProperty("alias", "\u522b\u540d,\u9ed8\u8ba4\u548cproperty\u4e00\u81f4", (DataType)StringType.GLOBAL).addProperty("agg", "\u805a\u5408\u65b9\u5f0f,count,sum,max,min,avg\u7b49", (DataType)StringType.GLOBAL))), SimplePropertyMetadata.of((String)"query", (String)"\u67e5\u8be2\u6761\u4ef6", (DataType)new ArrayType().elementType((DataType)new ObjectType().addProperty("interval", "\u65f6\u95f4\u95f4\u9694,\u5982: 1d", (DataType)StringType.GLOBAL).addProperty("format", "\u65f6\u95f4\u683c\u5f0f,\u9ed8\u8ba4yyyy-MM-dd", (DataType)StringType.GLOBAL).addProperty("from", "\u65f6\u95f4\u4ece,\u5982: 2020-09-01 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d", (DataType)StringType.GLOBAL).addProperty("to", "\u65f6\u95f4\u5230,\u5982: 2020-09-02 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d", (DataType)StringType.GLOBAL).addProperty("limit", "\u6570\u91cf\u9650\u5236", (DataType)IntType.GLOBAL).addProperty("filter", "\u8fc7\u6ee4\u6761\u4ef6,\u901a\u7528\u67e5\u8be2\u6761\u4ef6", (DataType)new ObjectType()))));
    }

    public static FunctionMetadata metadata() {
        return CommandMetadataResolver.resolve(QueryPropertyAggCommand.class);
    }
}

