/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.media;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.media.MediaInfo;

public class MediaStreamInfo
extends MediaInfo {
    @Nullable
    private String ssrc;
    private Map<String, Object> others;

    public void withOther(String key, Object value) {
        if (this.others == null) {
            this.others = new HashMap<String, Object>();
        }
        this.others.put(key, value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF((String)this.ssrc, (ObjectOutput)out);
        SerializeUtils.writeObject(this.others, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.ssrc = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.others = (Map)SerializeUtils.readObject((ObjectInput)in);
    }

    @Nullable
    public String getSsrc() {
        return this.ssrc;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setSsrc(@Nullable String ssrc) {
        this.ssrc = ssrc;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }
}

