/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.llm.chat;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.ai.cv.ImageData;
import org.jetlinks.sdk.server.ai.cv.UploadFileInfo;

public class ChatMessage
implements Externalizable {
    @Schema(title="\u6d88\u606f\u5185\u5bb9", description="\u5bf9\u8bdd\u6587\u672c\u6d88\u606f\u5185\u5bb9")
    private String content;
    @Schema(title="\u6d88\u606f\u56fe\u7247", description="\u5bf9\u8bdd\u56fe\u7247\u6d88\u606f\u5185\u5bb9")
    private List<ImageData> images;
    @Schema(title="\u4e0a\u4f20\u6587\u4ef6\u4fe1\u606f\u5217\u8868", description="\u5bf9\u8bdd\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9")
    public List<UploadFileInfo> files;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size;
        out.writeByte(1);
        SerializeUtils.writeNullableUTF((String)this.content, (ObjectOutput)out);
        if (this.images == null) {
            out.writeInt(0);
        } else {
            size = this.images.size();
            out.writeInt(size);
            for (ImageData image : this.images) {
                image.writeExternal(out);
            }
        }
        if (this.files == null) {
            out.writeInt(0);
        } else {
            size = this.files.size();
            out.writeInt(size);
            for (UploadFileInfo file : this.files) {
                file.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        byte ignore = in.readByte();
        this.content = SerializeUtils.readNullableUTF((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.images = new ArrayList<ImageData>(size);
            for (i = 0; i < size; ++i) {
                ImageData image = new ImageData();
                image.readExternal(in);
                this.images.add(image);
            }
        }
        if ((size = in.readInt()) > 0) {
            this.files = new ArrayList<UploadFileInfo>(size);
            for (i = 0; i < size; ++i) {
                UploadFileInfo file = new UploadFileInfo();
                file.readExternal(in);
                this.files.add(file);
            }
        }
    }

    public String getContent() {
        return this.content;
    }

    public List<ImageData> getImages() {
        return this.images;
    }

    public List<UploadFileInfo> getFiles() {
        return this.files;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setImages(List<ImageData> images) {
        this.images = images;
    }

    public void setFiles(List<UploadFileInfo> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<ImageData> this$images = this.getImages();
        List<ImageData> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        List<UploadFileInfo> this$files = this.getFiles();
        List<UploadFileInfo> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<ImageData> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        List<UploadFileInfo> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(content=" + this.getContent() + ", images=" + this.getImages() + ", files=" + this.getFiles() + ")";
    }
}

