/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.sdk.server.commons.cmd.UnboundedResponseCommand;
import org.jetlinks.sdk.server.device.DevicePropertyProperties;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DevicePropertySelector;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DeviceSelector;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.ProductSelector;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Flux;

@Schema(title="\u8ba2\u9605\u8bbe\u5907\u5168\u90e8\u5c5e\u6027\u6570\u636e", description="\u6839\u636e\u53c2\u6570\u8bbe\u5907\u7684\u5b9e\u65f6\u5c5e\u6027\u6570\u636e")
public class SubscribeDevicePropertiesCommand
extends AbstractCommand<Flux<DevicePropertyProperties>, SubscribeDevicePropertiesCommand>
implements UnboundedResponseCommand<DevicePropertyProperties> {
    public static final String DEVICE_IDS = "deviceIds";
    public static final String PRODUCT_ID = "productId";
    public static final String PROPERTY_ID = "propertyIds";

    @DeviceSelector(multiple=true)
    @Order(value=1)
    @Schema(title="\u8bbe\u5907ID\u96c6\u5408", description="\u4e3a\u7a7a\u8ba2\u9605\u6240\u6709\u8bbe\u5907")
    public List<String> getDeviceIds() {
        return ConverterUtils.convertToList(this.readable().get(DEVICE_IDS), String::valueOf);
    }

    public SubscribeDevicePropertiesCommand setDeviceIds(List<String> deviceIds) {
        return (SubscribeDevicePropertiesCommand)this.with(DEVICE_IDS, deviceIds);
    }

    @ProductSelector
    @Schema(title="\u4ea7\u54c1ID")
    @Order(value=0)
    public String getProductId() {
        return (String)this.getOrNull(PRODUCT_ID, String.class);
    }

    public SubscribeDevicePropertiesCommand setProductId(String productId) {
        return (SubscribeDevicePropertiesCommand)this.with(PRODUCT_ID, productId);
    }

    @DevicePropertySelector(multiple=true, deviceIdKey="deviceIds", productIdKey="productId")
    @Schema(title="\u5c5e\u6027ID\u96c6\u5408", description="\u4e3a\u7a7a\u8ba2\u9605\u6240\u6709\u5c5e\u6027")
    @Order(value=3)
    public List<String> getPropertyIds() {
        return ConverterUtils.convertToList(this.readable().get(PROPERTY_ID), String::valueOf);
    }

    public SubscribeDevicePropertiesCommand setPropertyIds(List<String> propertyIds) {
        return (SubscribeDevicePropertiesCommand)this.with(PROPERTY_ID, propertyIds);
    }
}

