/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jetlinks.sdk.server.commons.cmd.SubscribeCommand;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubscribeCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(SubscribeCommandHandler.class);
    protected final Map<Class<?>, List<Function<Object, Mono<Void>>>> callbacks = new ConcurrentHashMap();

    public <T, CMD extends SubscribeCommand<T, CMD>> Disposable addCallback(Class<T> eventClass, CMD cmd, Function<T, Mono<T>> callback) {
        return this.addCallback0(eventClass, obj -> ((Mono)callback.apply(eventClass.cast(obj))).then());
    }

    public <T> Disposable addCallback0(Class<T> eventClass, Function<Object, Mono<Void>> callback) {
        this.callbacks.computeIfAbsent(eventClass, ignore -> new CopyOnWriteArrayList()).add(callback);
        return () -> this.callbacks.compute(eventClass, (k, list) -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return null;
            }
            list.remove(callback);
            if (list.isEmpty()) {
                return null;
            }
            return list;
        });
    }

    public Mono<Void> handle(Object event) {
        return SubscribeCommandHandler.handle(event, this.callbacks.getOrDefault(event.getClass(), Collections.emptyList()));
    }

    private static Mono<Void> handle(Object event, List<Function<Object, Mono<Void>>> functions) {
        if (CollectionUtils.isEmpty(functions)) {
            return Mono.empty();
        }
        return Flux.fromIterable(functions).flatMap(callback -> (Publisher)callback.apply(event)).then();
    }
}

