/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public class ByteBufUtils {
    public static Flux<ByteBuf> splitByteBuf(ByteBuf data, int maxChunkSize) {
        int length = data.readableBytes();
        if (length <= maxChunkSize) {
            return Flux.just((Object)data);
        }
        return Flux.generate(() -> data, (buf, sink) -> {
            int readableBytes = buf.readableBytes();
            if (readableBytes == 0) {
                sink.complete();
                return buf;
            }
            if (readableBytes > maxChunkSize) {
                sink.next((Object)buf.retainedSlice(buf.readerIndex(), maxChunkSize));
                return buf.readerIndex(buf.readerIndex() + maxChunkSize);
            }
            sink.next((Object)buf.retainedSlice(buf.readerIndex(), buf.readableBytes()));
            sink.complete();
            return buf.readerIndex(buf.readableBytes());
        }, ReferenceCountUtil::safeRelease);
    }

    public static int computeBalanceEachSize(long fileLength, int lengthEachPart) {
        if (fileLength == 0L) {
            return lengthEachPart;
        }
        long parts = fileLength / (long)lengthEachPart;
        int eachSize = parts == 0L ? (int)fileLength : (int)(fileLength / parts);
        long eachRemainder = fileLength % (long)eachSize;
        if (eachRemainder > 0L) {
            eachSize += (int)Math.ceil((double)eachRemainder / (double)parts);
        }
        return eachSize;
    }

    public static Flux<ByteBuf> balanceBuffer(Flux<ByteBuf> buffer, int fixedLength) {
        return new ByteBufBalancer(fixedLength, buffer);
    }

    static class ByteBufBalancer
    extends FluxOperator<ByteBuf, ByteBuf> {
        final int fixedLength;

        protected ByteBufBalancer(int fixedLength, Flux<? extends ByteBuf> source) {
            super(source);
            this.fixedLength = fixedLength;
        }

        public void subscribe(@Nonnull CoreSubscriber<? super ByteBuf> actual) {
            this.source.subscribe((CoreSubscriber)new ByteBufBalancerSubscriber(this.fixedLength, actual));
        }
    }

    static class ByteBufBalancerSubscriber
    implements CoreSubscriber<ByteBuf>,
    Subscription {
        static final AtomicIntegerFieldUpdater<ByteBufBalancerSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ByteBufBalancerSubscriber.class, "wip");
        static final AtomicLongFieldUpdater<ByteBufBalancerSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ByteBufBalancerSubscriber.class, "requested");
        private final int fixedLength;
        private final CoreSubscriber<? super ByteBuf> actual;
        private volatile long requested;
        private volatile int wip;
        private volatile boolean done;
        private Throwable error;
        private volatile boolean cancelled;
        private Subscription s;
        private final Queue<ByteBuf> queue = (Queue)Queues.unboundedMultiproducer().get();
        private final List<ByteBuf> aggregate = new ArrayList<ByteBuf>(16);
        private int remaining = 0;

        ByteBufBalancerSubscriber(int fixedLength, CoreSubscriber<? super ByteBuf> actual) {
            this.actual = actual;
            this.fixedLength = fixedLength;
            this.remaining = fixedLength;
        }

        @Nonnull
        public Context currentContext() {
            return this.actual.currentContext();
        }

        public void onSubscribe(@Nonnull Subscription subscription) {
            if (this.s != null) {
                subscription.cancel();
                return;
            }
            this.s = subscription;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(@Nonnull ByteBuf buf) {
            if (this.done || this.cancelled) {
                ReferenceCountUtil.safeRelease((Object)buf);
                return;
            }
            this.queue.offer(buf);
            this.drain();
        }

        public void onError(@Nonnull Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (n <= 0L) {
                return;
            }
            Operators.addCap(REQUESTED, (Object)this, (long)n);
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            CoreSubscriber<? super ByteBuf> a = this.actual;
            do {
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                long r = this.requested;
                long e = 0L;
                block1: while (e != r) {
                    int offset;
                    int readable;
                    ByteBuf buf;
                    block20: {
                        boolean empty;
                        if (this.cancelled) {
                            this.cleanup();
                            return;
                        }
                        boolean d = this.done;
                        buf = this.queue.poll();
                        boolean bl = empty = buf == null;
                        if (d && empty) {
                            Throwable ex = this.error;
                            if (ex != null) {
                                this.cleanup();
                                a.onError(ex);
                            } else {
                                if (!this.aggregate.isEmpty()) {
                                    this.emitAggregate(a);
                                }
                                a.onComplete();
                            }
                            return;
                        }
                        if (empty) break;
                        readable = buf.readableBytes();
                        offset = 0;
                        do {
                            if (this.cancelled) {
                                ReferenceCountUtil.safeRelease((Object)buf);
                                this.cleanup();
                                return;
                            }
                            int need = this.remaining;
                            if (readable - offset < need) break block20;
                            if (need > 0) {
                                this.aggregate.add(buf.retainedSlice(offset, need));
                            }
                            offset += need;
                            readable = buf.readableBytes();
                            this.emitAggregate(a);
                            r = this.requested;
                            if (++e != r) continue;
                            if (offset < buf.readableBytes()) {
                                this.queue.offer(buf.retainedSlice(offset, buf.readableBytes() - offset));
                            }
                            ReferenceCountUtil.safeRelease((Object)buf);
                            continue block1;
                        } while (offset != buf.readableBytes());
                        ReferenceCountUtil.safeRelease((Object)buf);
                        continue;
                    }
                    int len = readable - offset;
                    if (len > 0) {
                        this.aggregate.add(buf.retainedSlice(offset, len));
                        this.remaining -= len;
                    }
                    ReferenceCountUtil.safeRelease((Object)buf);
                }
                if (e != 0L) {
                    Operators.produced(REQUESTED, (Object)this, (long)e);
                }
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                if (!this.done || !this.queue.isEmpty()) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    this.cleanup();
                    a.onError(ex);
                } else {
                    if (!this.aggregate.isEmpty()) {
                        this.emitAggregate(a);
                    }
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            if (this.requested > 0L) {
                this.s.request(1L);
            }
        }

        void emitAggregate(CoreSubscriber<? super ByteBuf> a) {
            int size = this.aggregate.size();
            if (size == 0) {
                this.remaining = this.fixedLength;
                return;
            }
            Object out = size == 1 ? this.aggregate.get(0) : Unpooled.compositeBuffer((int)size).addComponents(true, new ArrayList<ByteBuf>(this.aggregate));
            this.aggregate.clear();
            this.remaining = this.fixedLength;
            a.onNext(out);
        }

        void cleanup() {
            ByteBuf b;
            for (ByteBuf b2 : this.aggregate) {
                ReferenceCountUtil.safeRelease((Object)b2);
            }
            this.aggregate.clear();
            while ((b = this.queue.poll()) != null) {
                ReferenceCountUtil.safeRelease((Object)b);
            }
        }
    }
}

