/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetlinks.sdk.server.utils.JsonFieldExtractor;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.unit.DataSize;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ObjectMappers {
    public static final ObjectMapper JSON_MAPPER;
    public static final ObjectMapper CBOR_MAPPER;
    public static final ObjectMapper SMILE_MAPPER;
    public static final XmlMapper XML_MAPPER;

    public static String toJsonString(Object data) {
        return JSON_MAPPER.writeValueAsString(data);
    }

    public static byte[] toJsonBytes(Object data) {
        return JSON_MAPPER.writeValueAsBytes(data);
    }

    public static <T> T parseJson(byte[] data, Class<T> type) {
        return (T)JSON_MAPPER.readValue(data, type);
    }

    public static <T> T parseJson(InputStream data, Class<T> type) {
        return (T)JSON_MAPPER.readValue(data, type);
    }

    public static <T> T parseJson(String data, Class<T> type) {
        return (T)JSON_MAPPER.readValue(data, type);
    }

    public static <T> List<T> parseJsonArray(InputStream data, Class<T> type) {
        return (List)JSON_MAPPER.readerForListOf(type).readValue(data);
    }

    public static <T> List<T> parseJsonArray(byte[] data, Class<T> type) {
        return (List)JSON_MAPPER.readerForListOf(type).readValue(data);
    }

    public static <T> List<T> parseJsonArray(String data, Class<T> type) {
        return (List)JSON_MAPPER.readerForListOf(type).readValue(data);
    }

    public static <T> Flux<T> parseJsonStream(Flux<DataBuffer> stream, Class<T> type) {
        return ObjectMappers.parseJsonStream(stream, type, JSON_MAPPER);
    }

    public static <T> Flux<T> parseJsonStream(Flux<DataBuffer> stream, Class<T> type, ObjectMapper mapper) {
        Jackson2JsonDecoder decoder = new Jackson2JsonDecoder(mapper, new MimeType[0]);
        decoder.setMaxInMemorySize((int)DataSize.ofMegabytes((long)8L).toBytes());
        return decoder.decode(stream, ResolvableType.forType(type), null, null).cast(type);
    }

    public static <T> Flux<T> parseJsonStreamField(Flux<DataBuffer> stream, String fieldPath, Class<T> valueType) {
        return ObjectMappers.parseJsonStreamField(stream, fieldPath, valueType, JSON_MAPPER);
    }

    public static <T> Flux<T> parseJsonStreamField(Flux<DataBuffer> stream, String fieldPath, Class<T> valueType, ObjectMapper mapper) {
        JsonFieldExtractor extractor = new JsonFieldExtractor(fieldPath, mapper);
        return extractor.extractField(stream, valueType);
    }

    public static Flux<byte[]> toJsonStream(Flux<?> objectStream) {
        return ObjectMappers.toJsonStream(objectStream, JSON_MAPPER);
    }

    public static Flux<byte[]> toJsonStream(Flux<?> objectStream, ObjectMapper mapper) {
        return Flux.create(sink -> {
            OutputStream stream = ObjectMappers.createStream((FluxSink<byte[]>)sink, 8096);
            JsonGenerator generator = ObjectMappers.createJsonGenerator(mapper, stream);
            try {
                generator.writeStartArray();
            }
            catch (IOException e) {
                sink.error((Throwable)e);
                return;
            }
            Disposable writer = objectStream.publishOn(Schedulers.single((Scheduler)Schedulers.boundedElastic())).subscribe(next -> ObjectMappers.writeObject(generator, next), arg_0 -> ((FluxSink)sink).error(arg_0), () -> {
                try {
                    generator.writeEndArray();
                }
                catch (IOException e) {
                    sink.error((Throwable)e);
                    return;
                }
                ObjectMappers.safeClose(generator);
                sink.complete();
            }, Context.of((ContextView)sink.contextView()));
            sink.onDispose(() -> {
                ObjectMappers.safeClose(generator);
                writer.dispose();
            });
        });
    }

    private static OutputStream createStream(final FluxSink<byte[]> sink, int bufferSize) {
        return new BufferedOutputStream(new OutputStream(){

            @Override
            public void write(@Nonnull byte[] b, int off, int len) {
                if (len == b.length) {
                    sink.next((Object)b);
                } else {
                    sink.next((Object)Arrays.copyOfRange(b, off, off + len));
                }
            }

            @Override
            public void write(@Nonnull byte[] b) {
                sink.next((Object)b);
            }

            @Override
            public void write(int b) {
                sink.next((Object)new byte[]{(byte)b});
            }
        }, bufferSize){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    sink.complete();
                }
            }
        };
    }

    private static JsonGenerator createJsonGenerator(ObjectMapper mapper, OutputStream stream) {
        return mapper.createGenerator(stream);
    }

    private static void writeObject(JsonGenerator generator, Object data) {
        generator.writePOJO(data);
    }

    private static void safeClose(JsonGenerator closeable) {
        if (closeable.isClosed()) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        ObjectMapper smile;
        ObjectMapper cbor;
        JSON_MAPPER = Jackson2ObjectMapperBuilder.json().build().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        XML_MAPPER = new XmlMapper();
        XML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        XML_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        XML_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        XML_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        XML_MAPPER.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        try {
            cbor = Jackson2ObjectMapperBuilder.cbor().build().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        catch (Throwable ignore) {
            cbor = null;
        }
        CBOR_MAPPER = cbor;
        try {
            smile = Jackson2ObjectMapperBuilder.smile().build().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        catch (Throwable ignore) {
            smile = null;
        }
        SMILE_MAPPER = smile;
    }
}

