/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.cv;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import lombok.Generated;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.file.FileData;
import org.springframework.util.ObjectUtils;

public class ImageData
implements FileData,
Externalizable {
    @Schema(description="\u56fe\u7247\u6e90id,\u4f8b\u5982\u89c6\u9891\u6e90id")
    private String id;
    @Schema(description="\u56fe\u7247\u6570\u636e")
    private ByteBuf data;
    @Schema(description="\u56fe\u7247\u7c7b\u578b")
    private Type type;
    @Schema(description="\u5176\u4ed6\u4fe1\u606f")
    private Map<String, Object> others;

    @Override
    public String name() {
        return ObjectUtils.isEmpty(this.others) ? "image.jpg" : (String)this.others.getOrDefault("name", "image.jpg");
    }

    @Deprecated
    public ImageData withName(String key, String value) {
        this.withOther("name", value);
        return this;
    }

    public ImageData withName(String value) {
        this.withOther("name", value);
        return this;
    }

    public ImageData withOther(String key, Object value) {
        this.othersWriter().put(key, value);
        return this;
    }

    private synchronized Map<String, Object> othersWriter() {
        return this.others == null ? (this.others = Maps.newConcurrentMap()) : this.others;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeNullableUTF((String)this.id, (ObjectOutput)out);
        SerializeUtils.writeKeyValue(this.others, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.data, (ObjectOutput)out);
        out.writeByte(this.type.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.others = SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize);
        this.data = (ByteBuf)SerializeUtils.readObject((ObjectInput)in);
        this.type = Type.ALL[in.readByte()];
    }

    public ByteBuf getData() {
        return this.body();
    }

    @Override
    public ByteBuf body() {
        return this.data == null ? null : Unpooled.unreleasableBuffer((ByteBuf)this.data);
    }

    @Override
    public void setUrl(String url) {
        this.withOther("url", url);
    }

    @Override
    public String getUrl() {
        return this.others == null ? null : (String)this.others.get("url");
    }

    @Override
    public void release() {
        ReferenceCountUtil.safeRelease((Object)this.data);
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setData(ByteBuf data) {
        this.data = data;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Map<String, Object> getOthers() {
        return this.others;
    }

    public static enum Type {
        original("\u539f\u59cb\u56fe\u50cf"),
        labeled("\u8fb9\u6846\u6807\u8bb0"),
        segmented("\u8bed\u4e49\u5206\u5272"),
        instance("\u5b9e\u4f8b\u5206\u5272"),
        keypoint("\u5173\u952e\u70b9\u6807\u8bb0");

        public static final Type[] ALL;
        private final String name;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private Type(String name) {
            this.name = name;
        }

        static {
            ALL = Type.values();
        }
    }
}

