/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.cv;

import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.ai.cv.AiCommandResult;
import org.jetlinks.sdk.server.ai.cv.ImageData;
import org.jetlinks.sdk.server.file.FileData;

@Schema(title="\u76ee\u6807\u68c0\u6d4b\u7ed3\u679c")
public class ObjectDetectionResult
extends AiCommandResult<ObjectDetectionResult> {
    @Schema(description="\u76ee\u6807\u68c0\u6d4b\u6e90id,\u4f8b\u5982\u89c6\u9891\u6e90id")
    private String sourceId;
    @Schema(title="\u56fe\u50cf\u6570\u636e")
    private List<ImageData> images;
    @Schema(title="\u68c0\u6d4b\u5230\u7684\u5bf9\u8c61")
    private List<DetectedObject> objects;
    @Schema(title="\u5176\u4ed6\u4fe1\u606f")
    private Map<String, Object> others;

    @Override
    public List<? extends FileData> files() {
        return this.images;
    }

    @Override
    public Map<String, Object> toLightWeighMap() {
        Map map = (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[]{"images"});
        map.put("images", this.imagesToSimpleMap());
        return map;
    }

    @Override
    public List<Map<String, Object>> flat() {
        List<Map<String, Object>> maps;
        List<Map<String, Object>> _images = this.imagesToSimpleMap();
        if (CollectionUtils.isNotEmpty(this.objects)) {
            maps = new ArrayList<Map<String, Object>>(this.objects.size());
            for (DetectedObject object : this.objects) {
                FlatData from = FlatData.from(this, object);
                Map data = (Map)FastBeanCopier.copy((Object)((Object)from), new HashMap(), (String[])new String[0]);
                data.put("images", _images);
                maps.add(data);
            }
        } else {
            Map copy = (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[]{"images", "objects"});
            copy.put("images", _images);
            maps = Collections.singletonList(copy);
        }
        return maps;
    }

    private List<Map<String, Object>> imagesToSimpleMap() {
        if (CollectionUtils.isNotEmpty(this.images)) {
            ArrayList<Map<String, Object>> _images = new ArrayList<Map<String, Object>>(this.images.size());
            for (ImageData image : this.images) {
                _images.add((Map)FastBeanCopier.copy((Object)image, new HashMap(), (String[])new String[]{"data"}));
            }
            return _images;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF((String)this.sourceId, (ObjectOutput)out);
        if (CollectionUtils.isEmpty(this.images)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.images.size());
            for (ImageData img : this.images) {
                img.writeExternal(out);
            }
        }
        if (CollectionUtils.isEmpty(this.objects)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.objects.size());
            for (DetectedObject object : this.objects) {
                object.writeExternal(out);
            }
        }
        SerializeUtils.writeKeyValue(this.others, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size;
        super.readExternal(in);
        this.sourceId = SerializeUtils.readNullableUTF((ObjectInput)in);
        int sizeImg = in.readInt();
        if (sizeImg > 0) {
            this.images = new ArrayList<ImageData>(sizeImg);
            for (int i = 0; i < sizeImg; ++i) {
                ImageData img = new ImageData();
                img.readExternal(in);
                this.images.add(img);
            }
        } else {
            this.images = new ArrayList<ImageData>(0);
        }
        if ((size = in.readInt()) > 0) {
            this.objects = new ArrayList<DetectedObject>(size);
            for (int i = 0; i < size; ++i) {
                DetectedObject object = new DetectedObject();
                object.readExternal(in);
                this.objects.add(object);
            }
        } else {
            this.objects = new ArrayList<DetectedObject>(0);
        }
        this.others = SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize);
    }

    @Override
    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setImages(List<ImageData> images) {
        this.images = images;
    }

    @Generated
    public void setObjects(List<DetectedObject> objects) {
        this.objects = objects;
    }

    @Generated
    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }

    @Override
    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public List<ImageData> getImages() {
        return this.images;
    }

    @Generated
    public List<DetectedObject> getObjects() {
        return this.objects;
    }

    @Generated
    public Map<String, Object> getOthers() {
        return this.others;
    }

    public static class DetectedObject
    implements Externalizable {
        @Schema(title="\u5bf9\u8c61ID")
        private String objectId;
        @Schema(title="\u6807\u7b7e")
        private String label;
        @Schema(title="\u7f6e\u4fe1\u5ea6")
        private float score;
        @Schema(title="\u8fb9\u6846")
        private float[] box;
        @Schema(title="\u6807\u6ce8\u4fe1\u606f")
        private Map<String, Object> annotations;
        @Schema(title="\u5176\u4ed6\u4fe1\u606f")
        private Map<String, Object> others;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            SerializeUtils.writeNullableUTF((String)this.objectId, (ObjectOutput)out);
            SerializeUtils.writeNullableUTF((String)this.label, (ObjectOutput)out);
            out.writeFloat(this.score);
            out.writeInt(this.box == null ? 0 : this.box.length);
            if (this.box != null) {
                for (float v : this.box) {
                    out.writeFloat(v);
                }
            }
            SerializeUtils.writeKeyValue(this.annotations, (ObjectOutput)out);
            SerializeUtils.writeKeyValue(this.others, (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.objectId = SerializeUtils.readNullableUTF((ObjectInput)in);
            this.label = SerializeUtils.readNullableUTF((ObjectInput)in);
            this.score = in.readFloat();
            int size = in.readInt();
            this.box = new float[size];
            for (int i = 0; i < size; ++i) {
                this.box[i] = in.readFloat();
            }
            this.annotations = SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize);
            this.others = SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize);
        }

        @Generated
        public String getObjectId() {
            return this.objectId;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public float getScore() {
            return this.score;
        }

        @Generated
        public float[] getBox() {
            return this.box;
        }

        @Generated
        public Map<String, Object> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Map<String, Object> getOthers() {
            return this.others;
        }

        @Generated
        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setScore(float score) {
            this.score = score;
        }

        @Generated
        public void setBox(float[] box) {
            this.box = box;
        }

        @Generated
        public void setAnnotations(Map<String, Object> annotations) {
            this.annotations = annotations;
        }

        @Generated
        public void setOthers(Map<String, Object> others) {
            this.others = others;
        }
    }

    public static class FlatData
    extends GenericHeaderSupport<FlatData> {
        @Schema(title="\u6570\u636eid")
        private String outputId;
        @Schema(title="\u662f\u5426\u6210\u529f\u54cd\u5e94")
        private boolean success;
        @Schema(title="\u9519\u8bef\u4fe1\u606f")
        private String errorMessage;
        @Schema(title="\u9519\u8bef\u7801")
        private String errorCode;
        @Schema(title="\u65f6\u95f4\u6233")
        private long timestamp;
        @Schema(description="\u76ee\u6807\u68c0\u6d4b\u6e90id,\u4f8b\u5982\u89c6\u9891\u6e90id")
        private String sourceId;
        @Schema(title="\u5bf9\u8c61ID")
        private String objectId;
        @Schema(title="\u6807\u7b7e")
        private String label;
        @Schema(title="\u7f6e\u4fe1\u5ea6")
        private float score;
        @Schema(title="\u8fb9\u6846")
        private float[] box;
        @Schema(title="\u6807\u6ce8\u4fe1\u606f")
        private Map<String, Object> annotations;
        @Schema(title="\u5bf9\u8c61\u5176\u4ed6\u4fe1\u606f")
        private Map<String, Object> objectOthers;
        @Schema(title="\u5176\u4ed6\u4fe1\u606f")
        private Map<String, Object> others;

        public static FlatData from(ObjectDetectionResult result, DetectedObject object) {
            FlatData copy = (FlatData)((Object)FastBeanCopier.copy((Object)result, (Object)((Object)new FlatData()), (String[])new String[]{"images", "objects"}));
            FlatData data = (FlatData)((Object)FastBeanCopier.copy((Object)object, (Object)((Object)copy), (String[])new String[]{"others"}));
            data.setObjectOthers(object.getOthers());
            return data;
        }

        @Generated
        public String getOutputId() {
            return this.outputId;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public String getErrorCode() {
            return this.errorCode;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getSourceId() {
            return this.sourceId;
        }

        @Generated
        public String getObjectId() {
            return this.objectId;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public float getScore() {
            return this.score;
        }

        @Generated
        public float[] getBox() {
            return this.box;
        }

        @Generated
        public Map<String, Object> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Map<String, Object> getObjectOthers() {
            return this.objectOthers;
        }

        @Generated
        public Map<String, Object> getOthers() {
            return this.others;
        }

        @Generated
        public void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Generated
        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Generated
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Generated
        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setScore(float score) {
            this.score = score;
        }

        @Generated
        public void setBox(float[] box) {
            this.box = box;
        }

        @Generated
        public void setAnnotations(Map<String, Object> annotations) {
            this.annotations = annotations;
        }

        @Generated
        public void setObjectOthers(Map<String, Object> objectOthers) {
            this.objectOthers = objectOthers;
        }

        @Generated
        public void setOthers(Map<String, Object> others) {
            this.others = others;
        }
    }
}

