/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.llm.chat;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.ai.cv.ImageData;
import org.jetlinks.sdk.server.ai.cv.UploadFileInfo;
import org.jetlinks.sdk.server.ai.llm.LlmMessage;

public class ChatMessage
extends LlmMessage<ChatMessage>
implements Externalizable {
    @Schema(title="\u6d88\u606f\u5185\u5bb9", description="\u5bf9\u8bdd\u6587\u672c\u6d88\u606f\u5185\u5bb9")
    private String content;
    @Schema(title="\u6d88\u606f\u56fe\u7247", description="\u5bf9\u8bdd\u56fe\u7247\u6d88\u606f\u5185\u5bb9")
    private List<ImageData> images;
    @Schema(title="\u4e0a\u4f20\u6587\u4ef6\u4fe1\u606f\u5217\u8868", description="\u5bf9\u8bdd\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9")
    public List<UploadFileInfo> files;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size;
        super.writeExternal(out);
        out.writeByte(1);
        SerializeUtils.writeNullableUTF((String)this.content, (ObjectOutput)out);
        if (this.images == null) {
            out.writeInt(0);
        } else {
            size = this.images.size();
            out.writeInt(size);
            for (ImageData image : this.images) {
                image.writeExternal(out);
            }
        }
        if (this.files == null) {
            out.writeInt(0);
        } else {
            size = this.files.size();
            out.writeInt(size);
            for (UploadFileInfo file : this.files) {
                file.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        super.readExternal(in);
        byte ignore = in.readByte();
        this.content = SerializeUtils.readNullableUTF((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.images = new ArrayList<ImageData>(size);
            for (i = 0; i < size; ++i) {
                ImageData image = new ImageData();
                image.readExternal(in);
                this.images.add(image);
            }
        }
        if ((size = in.readInt()) > 0) {
            this.files = new ArrayList<UploadFileInfo>(size);
            for (i = 0; i < size; ++i) {
                UploadFileInfo file = new UploadFileInfo();
                file.readExternal(in);
                this.files.add(file);
            }
        }
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<ImageData> getImages() {
        return this.images;
    }

    @Generated
    public List<UploadFileInfo> getFiles() {
        return this.files;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setImages(List<ImageData> images) {
        this.images = images;
    }

    @Generated
    public void setFiles(List<UploadFileInfo> files) {
        this.files = files;
    }
}

