/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.llm.chat;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.ai.cv.AiCommandResult;
import org.jetlinks.sdk.server.ai.cv.ImageData;
import org.jetlinks.sdk.server.ai.cv.UploadFileInfo;
import org.jetlinks.sdk.server.file.FileData;

public class ChatResponse
extends AiCommandResult<ChatResponse>
implements Externalizable {
    @Schema(title="\u54cd\u5e94\u7c7b\u578b")
    private Type type;
    @Schema(title="\u54cd\u5e94\u6587\u672c\u5185\u5bb9", description="\u5bf9\u8bdd\u6587\u672c\u6d88\u606f\u5185\u5bb9")
    private String content;
    @Schema(title="\u54cd\u5e94\u56fe\u7247\u5185\u5bb9", description="\u5bf9\u8bdd\u4ea7\u751f\u7684\u56fe\u7247\u5185\u5bb9")
    private List<ImageData> images;
    @Schema(title="\u54cd\u5e94\u6587\u4ef6\u5185\u5bb9", description="\u5bf9\u8bdd\u4ea7\u751f\u7684\u6587\u4ef6\u5185\u5bb9")
    private List<UploadFileInfo> files;

    @Override
    public List<? extends FileData> files() {
        ArrayList<FileData> fileData = new ArrayList<FileData>();
        if (this.images != null) {
            fileData.addAll(this.images);
        }
        if (this.files != null) {
            fileData.addAll(this.files);
        }
        return fileData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeByte(this.type.ordinal());
        SerializeUtils.writeKeyValue((Map)this.getHeaders(), (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.content, (ObjectOutput)out);
        if (this.images == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.images.size());
            for (ImageData image : this.images) {
                image.writeExternal(out);
            }
        }
        if (this.files == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.files.size());
            for (UploadFileInfo fileData : this.files) {
                fileData.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileData image;
        int i;
        super.readExternal(in);
        byte ignore = in.readByte();
        this.type = Type.ALL[in.readByte()];
        this.setHeaders(SerializeUtils.readMap((ObjectInput)in, ConcurrentHashMap::new));
        this.content = SerializeUtils.readNullableUTF((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.images = new ArrayList<ImageData>(size);
            for (i = 0; i < size; ++i) {
                image = new ImageData();
                ((ImageData)image).readExternal(in);
                this.images.add((ImageData)image);
            }
        }
        if ((size = in.readInt()) > 0) {
            this.files = new ArrayList<UploadFileInfo>(size);
            for (i = 0; i < size; ++i) {
                image = new UploadFileInfo();
                ((UploadFileInfo)image).readExternal(in);
                this.files.add((UploadFileInfo)image);
            }
        }
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<ImageData> getImages() {
        return this.images;
    }

    @Generated
    public List<UploadFileInfo> getFiles() {
        return this.files;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setImages(List<ImageData> images) {
        this.images = images;
    }

    @Generated
    public void setFiles(List<UploadFileInfo> files) {
        this.files = files;
    }

    public static enum Type {
        complete,
        streaming;

        static final Type[] ALL;

        static {
            ALL = Type.values();
        }
    }
}

