/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.auth.DimensionInfo;

public class GrantScope
implements Externalizable {
    @Schema(title="\u6388\u6743\u7ef4\u5ea6", description="\u5982\u6388\u6743\u8bbf\u95ee\u6307\u5b9a\u7684\u7ec4\u7ec7,\u89d2\u8272\u7b49.")
    private List<DimensionInfo> dimensions;
    @Schema(title="\u6388\u6743\u6743\u9650", description="\u5982\u6388\u6743\u8bbf\u95ee\u6307\u5b9a\u7684\u6743\u9650\u7b49.")
    private List<Permit> permissions;
    @Schema(title="\u5206\u7ec4", hidden=true)
    private List<String> groups;
    private Map<String, Object> attributes;

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.dimensions) && CollectionUtils.isEmpty(this.permissions) && CollectionUtils.isEmpty(this.groups);
    }

    public GrantScope addDimension(String type, String id) {
        return this.addDimension(type, id, null);
    }

    public GrantScope addDimension(String type, String id, Map<String, Object> options) {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<DimensionInfo>();
        }
        this.dimensions.add(new DimensionInfo(type, id, options));
        return this;
    }

    public GrantScope addPermission(String id, String ... action) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permit>();
        }
        this.permissions.add(Permit.of(id, action));
        return this;
    }

    public GrantScope addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject(this.groups, (ObjectOutput)out);
        int size = this.dimensions == null ? 0 : this.dimensions.size();
        out.writeInt(size);
        if (this.dimensions != null) {
            for (DimensionInfo dimension : this.dimensions) {
                dimension.writeExternal(out);
            }
        }
        size = this.permissions == null ? 0 : this.permissions.size();
        out.writeInt(size);
        if (this.permissions != null) {
            for (Permit permission : this.permissions) {
                permission.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.groups = (List)SerializeUtils.readObject((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.dimensions = new ArrayList<DimensionInfo>(size);
            for (i = 0; i < size; ++i) {
                DimensionInfo dimension = new DimensionInfo();
                dimension.readExternal(in);
                this.dimensions.add(dimension);
            }
        }
        if ((size = in.readInt()) > 0) {
            this.permissions = new ArrayList<Permit>(size);
            for (i = 0; i < size; ++i) {
                Permit permission = new Permit();
                permission.readExternal(in);
                this.permissions.add(permission);
            }
        }
    }

    @Generated
    public List<DimensionInfo> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public List<Permit> getPermissions() {
        return this.permissions;
    }

    @Generated
    public List<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setDimensions(List<DimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setPermissions(List<Permit> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class Permit
    implements Externalizable {
        @Schema(title="\u6743\u9650ID")
        private String id;
        @Schema(title="\u6743\u9650\u52a8\u4f5c")
        private Set<String> actions;

        public Permit() {
        }

        public Permit(String idAndActions) {
            String[] split = idAndActions.split(":");
            this.id = split[0];
            this.actions = Sets.newHashSet((Object[])split[1].split(","));
        }

        public static Permit of(String id, Set<String> actions) {
            Permit permit = new Permit();
            permit.setId(id);
            permit.setActions(actions);
            return permit;
        }

        public static Permit of(String id, String ... actions) {
            return Permit.of(id, Sets.newHashSet((Object[])actions));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            SerializeUtils.writeNullableUTF((String)this.id, (ObjectOutput)out);
            SerializeUtils.writeObject(this.actions, (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = SerializeUtils.readNullableUTF((ObjectInput)in);
            this.actions = (Set)SerializeUtils.readObject((ObjectInput)in);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Set<String> getActions() {
            return this.actions;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setActions(Set<String> actions) {
            this.actions = actions;
        }
    }
}

