/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import lombok.Generated;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.utils.SerializeUtils;

public class CachedDeviceProperty
implements Externalizable {
    private String property;
    private Object value;
    private long timestamp;
    private String state;

    public static CachedDeviceProperty of(ThingProperty property) {
        CachedDeviceProperty prop = new CachedDeviceProperty();
        prop.timestamp = property.getTimestamp();
        prop.property = property.getProperty();
        prop.value = property.getValue();
        prop.state = property.getState();
        return prop;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeNullableUTF((String)this.property, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.value, (ObjectOutput)out);
        out.writeLong(this.timestamp);
        SerializeUtils.writeNullableUTF((String)this.state, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.property = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.value = SerializeUtils.readObject((ObjectInput)in);
        this.timestamp = in.readLong();
        this.state = SerializeUtils.readNullableUTF((ObjectInput)in);
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }
}

