/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.sdk.server.commons.cmd.UnboundedResponseCommand;
import org.jetlinks.sdk.server.device.DeviceProperty;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DevicePropertySelector;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DeviceSelector;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.ProductSelector;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Flux;

@Schema(title="\u8ba2\u9605\u8bbe\u5907\u5c5e\u6027\u6570\u636e", description="\u6839\u636e\u53c2\u6570\u8bbe\u5907\u7684\u5b9e\u65f6\u5c5e\u6027\u6570\u636e")
public class SubscribeDevicePropertyCommand
extends AbstractCommand<Flux<DeviceProperty>, SubscribeDevicePropertyCommand>
implements UnboundedResponseCommand<DeviceProperty> {
    public static final String DEVICE_IDS = "deviceIds";
    public static final String PRODUCT_ID = "productId";
    public static final String PROPERTY_ID = "propertyIds";
    public static final String HISTORY = "history";

    @DeviceSelector(multiple=true)
    @Order(value=1)
    @Schema(title="\u8bbe\u5907ID\u96c6\u5408", description="\u4e3a\u7a7a\u8ba2\u9605\u6240\u6709\u8bbe\u5907")
    public List<String> getDeviceIds() {
        return ConverterUtils.convertToList(this.readable().get(DEVICE_IDS), String::valueOf);
    }

    public SubscribeDevicePropertyCommand setDeviceIds(List<String> deviceIds) {
        return (SubscribeDevicePropertyCommand)this.with(DEVICE_IDS, deviceIds);
    }

    public static FunctionMetadata metadata() {
        return CommandMetadataResolver.resolve(SubscribeDevicePropertyCommand.class);
    }

    @ProductSelector
    @Schema(title="\u4ea7\u54c1ID")
    @Order(value=0)
    public String getProductId() {
        return (String)this.getOrNull(PRODUCT_ID, String.class);
    }

    public SubscribeDevicePropertyCommand setProductId(String productId) {
        return (SubscribeDevicePropertyCommand)this.with(PRODUCT_ID, productId);
    }

    @DevicePropertySelector(multiple=true, deviceIdKey="deviceIds", productIdKey="productId")
    @Schema(title="\u5c5e\u6027ID\u96c6\u5408", description="\u4e3a\u7a7a\u8ba2\u9605\u6240\u6709\u5c5e\u6027")
    @Order(value=3)
    public List<String> getPropertyIds() {
        return ConverterUtils.convertToList(this.readable().get(PROPERTY_ID), String::valueOf);
    }

    public SubscribeDevicePropertyCommand setPropertyIds(List<String> propertyIds) {
        return (SubscribeDevicePropertyCommand)this.with(PROPERTY_ID, propertyIds);
    }

    @Schema(title="\u5386\u53f2\u6570\u636e", description="\u4e3a\u7a7a\u9ed8\u8ba4\u4e3a0")
    public Integer getHistory() {
        return (Integer)org.jetlinks.core.utils.ConverterUtils.convert((Object)this.readable().getOrDefault(HISTORY, 0), Integer.class);
    }
}

