/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.file;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.InputStream;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.utils.ConverterUtils;
import org.jetlinks.sdk.server.file.FileInfo;
import org.jetlinks.sdk.server.utils.ByteBufUtils;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class UploadFileCommand
extends AbstractCommand<Mono<FileInfo>, UploadFileCommand> {
    public String getFileId() {
        return (String)this.getOrNull("id", String.class);
    }

    public UploadFileCommand withFileId(String id) {
        return (UploadFileCommand)this.with("id", id);
    }

    public String getSessionId() {
        return (String)this.readable().get("sessionId");
    }

    public UploadFileCommand withSessionId(String sessionId) {
        return (UploadFileCommand)this.with("sessionId", sessionId);
    }

    public ByteBuf getContent() {
        Object content = this.readable().get("content");
        if (content instanceof ByteBuf) {
            return (ByteBuf)content;
        }
        if (content instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])content));
        }
        if (content instanceof String) {
            return Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode((String)content));
        }
        throw new UnsupportedOperationException("unsupported file content " + content);
    }

    public UploadFileCommand withContent(ByteBuf content) {
        return (UploadFileCommand)this.with("content", content);
    }

    public long getOffset() {
        return (Long)ConverterUtils.convert((Object)this.readable().getOrDefault("offset", 0), Long.class);
    }

    public UploadFileCommand withOffset(long offset) {
        return (UploadFileCommand)this.with("offset", offset);
    }

    public boolean isSharding() {
        Boolean isSharding = this.readable().getOrDefault("sharding", false);
        return Boolean.TRUE.equals(isSharding) || "true".equals(isSharding) || "1".equals(isSharding);
    }

    public UploadFileCommand withSharding(long offset) {
        return ((UploadFileCommand)this.with("sharding", true)).withOffset(offset);
    }

    public long getContentLength() {
        return (Long)ConverterUtils.convert((Object)this.readable().getOrDefault("contentLength", 0), Long.class);
    }

    public UploadFileCommand withContentLength(long contentLength) {
        return (UploadFileCommand)this.with("contentLength", contentLength);
    }

    public String getFileName() {
        return (String)this.readable().get("fileName");
    }

    public UploadFileCommand withFileName(String name) {
        return (UploadFileCommand)this.with("fileName", name);
    }

    public String getContentType() {
        return (String)this.readable().get("contentType");
    }

    public UploadFileCommand withContentType(String contentType) {
        return (UploadFileCommand)this.with("contentType", contentType);
    }

    public static Flux<ByteBuf> splitByteBuf(ByteBuf data, int maxChunkSize) {
        return ByteBufUtils.splitByteBuf(data, maxChunkSize);
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, ByteBuf data, int maxChunkSize, Consumer<UploadFileCommand> consumer) {
        return UploadFileCommand.execute(cmd, data.readableBytes(), UploadFileCommand.splitByteBuf(data, maxChunkSize), consumer);
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, InputStream data, int bufferSize, Consumer<UploadFileCommand> consumer) {
        return Mono.defer(() -> UploadFileCommand.execute0(cmd, data, bufferSize, consumer)).subscribeOn(Schedulers.boundedElastic());
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, long fileLength, Flux<ByteBuf> chunk, Consumer<UploadFileCommand> consumer) {
        String sessionId = (String)IDGenerator.RANDOM.generate();
        AtomicLong offset = new AtomicLong();
        return chunk.flatMap(bytes -> {
            UploadFileCommand command = new UploadFileCommand();
            consumer.accept(command);
            ByteBuf wrap = Unpooled.unreleasableBuffer((ByteBuf)bytes);
            return ((Mono)cmd.execute((Command)command.withSessionId(sessionId).withSharding(offset.getAndAdd(bytes.readableBytes())).withContent(wrap).withContentLength(fileLength))).doFinally(ignore -> ReferenceCountUtil.safeRelease((Object)bytes));
        }, 8).filter(f -> StringUtils.hasText((String)f.getAccessUrl())).take(1L).singleOrEmpty();
    }

    public static Mono<FileInfo> execute(CommandSupport cmd, long fileLength, Flux<ByteBuf> chunk, int lengthEachPart, Consumer<UploadFileCommand> consumer) {
        lengthEachPart = ByteBufUtils.computeBalanceEachSize(fileLength, lengthEachPart);
        return UploadFileCommand.execute(cmd, fileLength, ByteBufUtils.balanceBuffer(chunk, lengthEachPart), consumer);
    }

    private static Mono<FileInfo> execute0(CommandSupport cmd, InputStream data, int bufferSize, Consumer<UploadFileCommand> consumer) {
        return UploadFileCommand.execute(cmd, data.available(), (Flux<ByteBuf>)DataBufferUtils.readInputStream(() -> data, (DataBufferFactory)new NettyDataBufferFactory(ByteBufAllocator.DEFAULT), (int)bufferSize).map(buffer -> ((NettyDataBuffer)buffer).getNativeBuffer()), consumer);
    }
}

