/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.geo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoShape;

@Generated
public class GeoObjectInfo
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    @NotBlank(message="[id]\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="id")
    private @NotBlank(message="[id]\u4e0d\u80fd\u4e3a\u7a7a") String id;
    @NotBlank(message="[objectType]\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u5bf9\u8c61\u7c7b\u578b")
    private @NotBlank(message="[objectType]\u4e0d\u80fd\u4e3a\u7a7a") String objectType;
    @NotBlank(message="[shapeType]\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u4f4d\u7f6e\u7c7b\u578b")
    private @NotBlank(message="[shapeType]\u4e0d\u80fd\u4e3a\u7a7a") String shapeType;
    @NotBlank(message="[objectId]\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u5bf9\u8c61id")
    private @NotBlank(message="[objectId]\u4e0d\u80fd\u4e3a\u7a7a") String objectId;
    @Schema(description="\u5c5e\u6027\u6807\u8bc6")
    private String property;
    private GeoPoint point;
    private GeoShape shape;
    @Schema(description="\u62d3\u5c55\u4fe1\u606f")
    private Map<String, Object> tags;
    @Schema(description="\u66f4\u65b0\u65f6\u95f4")
    private long timestamp;

    public void setPoint(GeoPoint point) {
        this.shapeType = GeoShape.Type.Point.name();
        this.point = point;
        this.shape = GeoShape.fromPoint((GeoPoint)point);
    }

    public void setShape(GeoShape shape) {
        if (shape == null) {
            this.shape = null;
            return;
        }
        this.shapeType = shape.getType().name();
        this.shape = shape;
        if (shape.getType() == GeoShape.Type.Point && this.point == null) {
            this.point = GeoPoint.of((Object)shape.getCoordinates());
        }
    }

    public static GeoObjectInfo of(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GeoObjectInfo) {
            return (GeoObjectInfo)obj;
        }
        if (obj instanceof Map) {
            GeoObjectInfo geoObject = (GeoObjectInfo)FastBeanCopier.copy((Object)obj, GeoObjectInfo.class, (String[])new String[]{"point", "shape"});
            Map map = (Map)obj;
            GeoPoint point = GeoPoint.of(map.get("point"));
            if (point != null) {
                geoObject.setPoint(point);
            } else {
                GeoShape shape = GeoShape.of(map.get("shape"));
                if (shape != null) {
                    geoObject.setShape(shape);
                }
            }
        }
        return null;
    }

    @Generated
    public static GeoObjectInfoBuilder builder() {
        return new GeoObjectInfoBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public String getShapeType() {
        return this.shapeType;
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public GeoPoint getPoint() {
        return this.point;
    }

    @Generated
    public GeoShape getShape() {
        return this.shape;
    }

    @Generated
    public Map<String, Object> getTags() {
        return this.tags;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Generated
    public void setShapeType(String shapeType) {
        this.shapeType = shapeType;
    }

    @Generated
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public GeoObjectInfo() {
    }

    @Generated
    public GeoObjectInfo(String id, String objectType, String shapeType, String objectId, String property, GeoPoint point, GeoShape shape, Map<String, Object> tags, long timestamp) {
        this.id = id;
        this.objectType = objectType;
        this.shapeType = shapeType;
        this.objectId = objectId;
        this.property = property;
        this.point = point;
        this.shape = shape;
        this.tags = tags;
        this.timestamp = timestamp;
    }

    @Generated
    public String toString() {
        return "GeoObjectInfo(id=" + this.getId() + ", objectType=" + this.getObjectType() + ", shapeType=" + this.getShapeType() + ", objectId=" + this.getObjectId() + ", property=" + this.getProperty() + ", point=" + this.getPoint() + ", shape=" + this.getShape() + ", tags=" + this.getTags() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public static class GeoObjectInfoBuilder {
        @Generated
        private String id;
        @Generated
        private String objectType;
        @Generated
        private String shapeType;
        @Generated
        private String objectId;
        @Generated
        private String property;
        @Generated
        private GeoPoint point;
        @Generated
        private GeoShape shape;
        @Generated
        private Map<String, Object> tags;
        @Generated
        private long timestamp;

        @Generated
        GeoObjectInfoBuilder() {
        }

        @Generated
        public GeoObjectInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder shapeType(String shapeType) {
            this.shapeType = shapeType;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder property(String property) {
            this.property = property;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder point(GeoPoint point) {
            this.point = point;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder shape(GeoShape shape) {
            this.shape = shape;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder tags(Map<String, Object> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public GeoObjectInfoBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public GeoObjectInfo build() {
            return new GeoObjectInfo(this.id, this.objectType, this.shapeType, this.objectId, this.property, this.point, this.shape, this.tags, this.timestamp);
        }

        @Generated
        public String toString() {
            return "GeoObjectInfo.GeoObjectInfoBuilder(id=" + this.id + ", objectType=" + this.objectType + ", shapeType=" + this.shapeType + ", objectId=" + this.objectId + ", property=" + this.property + ", point=" + this.point + ", shape=" + this.shape + ", tags=" + this.tags + ", timestamp=" + this.timestamp + ")";
        }
    }
}

