/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.handler;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.sdk.server.commons.cmd.SubscribeCommand;
import org.jetlinks.sdk.server.handler.EntitySubscribeType;
import org.jetlinks.sdk.server.handler.SubscribeCommandHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EntitySubscribeCommandRegisterHandler
extends SubscribeCommandHandler {
    public void register(BiConsumer<String, CommandHandler<EntityEventSubscribeCommand, Flux<Object>>> support, DataType entityDataType) {
        this.register(support, entityDataType, callback -> obj -> ((Mono)callback.apply(obj)).then());
    }

    public void register(BiConsumer<String, CommandHandler<EntityEventSubscribeCommand, Flux<Object>>> support, DataType entityDataType, Function<Function<Object, Mono<Object>>, Function<Object, Mono<Void>>> handleCallback) {
        for (EntitySubscribeType type : EntitySubscribeType.values()) {
            support.accept(type.getId(), EntityEventSubscribeCommand.createHandler(() -> {
                SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
                metadata.setId(type.getId());
                metadata.setName(type.getName());
                metadata.setDescription(type.getDescription());
                metadata.setOutput(type.getOutput().apply(entityDataType));
                return metadata;
            }, (cmd, callback) -> this.addCallback0(type.getEventClass(), obj -> (Mono)((Function)handleCallback.apply((Function<Object, Mono<Object>>)callback)).apply(obj)), () -> new EntityEventSubscribeCommand().withCommandId(type.getId())));
        }
    }

    @Generated
    public EntitySubscribeCommandRegisterHandler() {
    }

    public static class EntityEventSubscribeCommand
    extends SubscribeCommand<Object, EntityEventSubscribeCommand> {
        public String getCommandId() {
            return Optional.ofNullable(this.readable().get("commandId")).orElse(super.getCommandId());
        }

        public EntityEventSubscribeCommand withCommandId(String commandId) {
            this.writable().put("commandId", commandId);
            return this;
        }
    }
}

