/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.media;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.media.MediaRecordFile;

public class MediaRecord
implements Externalizable {
    private String id;
    private String deviceId;
    private String channelId;
    @Schema(description="\u5f55\u50cf\u5f00\u59cb\u65f6\u95f4")
    private Long startTime;
    @Schema(description="\u5f55\u50cf\u7ed3\u675f\u65f6\u95f4")
    private Long endTime;
    @Schema(description="\u89c6\u9891\u6d41\u5f00\u59cb\u65f6\u95f4")
    private Long streamStartTime;
    @Schema(description="\u89c6\u9891\u6d41\u7ed3\u675f\u65f6\u95f4")
    private Long streamEndTime;
    @Schema(description="\u6d41\u7c7b\u578b")
    private String streamType;
    @Schema(description="\u6d41ID")
    private String streamId;
    private List<MediaRecordFile> files;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeNullableUTF((String)this.deviceId, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.channelId, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.startTime, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.endTime, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.streamStartTime, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.streamEndTime, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.streamType, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.streamId, (ObjectOutput)out);
        if (this.files == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.files.size());
            for (MediaRecordFile file : this.files) {
                file.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deviceId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.channelId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.startTime = (Long)SerializeUtils.readObject((ObjectInput)in);
        this.endTime = (Long)SerializeUtils.readObject((ObjectInput)in);
        this.streamStartTime = (Long)SerializeUtils.readObject((ObjectInput)in);
        this.streamEndTime = (Long)SerializeUtils.readObject((ObjectInput)in);
        this.streamType = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.streamId = SerializeUtils.readNullableUTF((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.files = new ArrayList<MediaRecordFile>(size);
            for (int i = 0; i < size; ++i) {
                MediaRecordFile file = new MediaRecordFile();
                file.readExternal(in);
                this.files.add(file);
            }
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public String getChannelId() {
        return this.channelId;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Long getStreamStartTime() {
        return this.streamStartTime;
    }

    @Generated
    public Long getStreamEndTime() {
        return this.streamEndTime;
    }

    @Generated
    public String getStreamType() {
        return this.streamType;
    }

    @Generated
    public String getStreamId() {
        return this.streamId;
    }

    @Generated
    public List<MediaRecordFile> getFiles() {
        return this.files;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Generated
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setStreamStartTime(Long streamStartTime) {
        this.streamStartTime = streamStartTime;
    }

    @Generated
    public void setStreamEndTime(Long streamEndTime) {
        this.streamEndTime = streamEndTime;
    }

    @Generated
    public void setStreamType(String streamType) {
        this.streamType = streamType;
    }

    @Generated
    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    @Generated
    public void setFiles(List<MediaRecordFile> files) {
        this.files = files;
    }
}

