/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.media;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.sdk.server.media.MediaStreamInfo;
import org.jetlinks.sdk.server.utils.CastUtils;
import reactor.core.publisher.Mono;

@Schema(title="\u5f00\u59cb\u63a8\u6d41")
public class StartPushStreamingCommand
extends AbstractCommand<Mono<MediaStreamInfo>, StartPushStreamingCommand> {
    @Schema(description="\u8bbe\u5907ID")
    public String getDeviceId() {
        return (String)this.getOrNull("deviceId", String.class);
    }

    public StartPushStreamingCommand setDeviceId(String deviceId) {
        return (StartPushStreamingCommand)this.with("deviceId", deviceId);
    }

    @Schema(description="\u901a\u9053ID")
    public String getChannelId() {
        return (String)this.getOrNull("channelId", String.class);
    }

    public StartPushStreamingCommand setChannelId(String channelId) {
        return (StartPushStreamingCommand)this.with("channelId", channelId);
    }

    @Schema(description="\u6d41ID")
    public String getStreamId() {
        return (String)this.getOrNull("streamId", String.class);
    }

    public StartPushStreamingCommand setStreamId(String streamId) {
        return (StartPushStreamingCommand)this.with("streamId", streamId);
    }

    @Schema(description="\u63a8\u6d41\u76ee\u7684\u5730", example="rtsp://127.0.0.1/live/stream?token=xxx")
    public String getDestination() {
        return (String)this.getOrNull("destination", String.class);
    }

    public StartPushStreamingCommand setDestination(String destination) {
        return (StartPushStreamingCommand)this.with("destination", destination);
    }

    @Schema(description="SDP\u4fe1\u606f")
    public String getSdp() {
        return (String)this.getOrNull("sdp", String.class);
    }

    public StartPushStreamingCommand setSdp(String sdp) {
        return (StartPushStreamingCommand)this.with("sdp", sdp);
    }

    @Schema(description="\u662f\u5426\u672c\u5730\u64ad\u653e,true\u8868\u793a\u8fd4\u56de\u672c\u5730\u64ad\u653e\u5730\u5740.")
    public boolean isLocalPlayer() {
        return CastUtils.castBoolean(this.readable().get("localPlayer"));
    }

    public StartPushStreamingCommand setLocalPlayer(boolean localPlayer) {
        this.with("localPlayer", localPlayer);
        return this;
    }

    @Schema(description="\u63a8\u9001\u5f55\u50cf\u89c6\u9891\u6d41")
    public boolean isForRecord() {
        return CastUtils.castBoolean(this.readable().get("forRecord"));
    }

    public StartPushStreamingCommand setForRecord(boolean forRecord) {
        return (StartPushStreamingCommand)this.with("forRecord", forRecord);
    }

    @Schema(description="\u5f55\u50cf\u5f00\u59cb\u65f6\u95f4")
    public Long getStartWith() {
        return (Long)this.getOrNull("startWith", Long.class);
    }

    public StartPushStreamingCommand setStartWith(Long startWith) {
        return (StartPushStreamingCommand)this.with("startWith", startWith);
    }

    @Schema(description="\u5f55\u50cf\u7ed3\u675f\u65f6\u95f4")
    public Long getEndWith() {
        return (Long)this.getOrNull("endWith", Long.class);
    }

    public StartPushStreamingCommand setEndWith(Long endWith) {
        return (StartPushStreamingCommand)this.with("endWith", endWith);
    }

    @Schema(description="\u5f55\u50cf\u63a8\u6d41\u901f\u5ea6")
    public Integer getDownloadSpeed() {
        return (Integer)this.getOrNull("downloadSpeed", Integer.class);
    }

    @Schema(description="\u6d41\u6240\u5c5e\u5e94\u7528")
    public String getApp() {
        return (String)this.getOrNull("app", String.class);
    }

    public StartPushStreamingCommand setApp(String app) {
        return (StartPushStreamingCommand)this.with("app", app);
    }

    @Schema(description="\u662f\u5426\u4e3a\u4e91\u7aef\u5f55\u50cf")
    public boolean isServerRecord() {
        return CastUtils.castBoolean(this.readable().get("serverRecord"));
    }

    public StartPushStreamingCommand setServerRecord(boolean serverRecord) {
        return (StartPushStreamingCommand)this.with("serverRecord", serverRecord);
    }

    public StartPushStreamingCommand setDownloadSpeed(Integer downloadSpeed) {
        return (StartPushStreamingCommand)this.with("downloadSpeed", downloadSpeed);
    }

    public boolean isLive() {
        return this.getStartWith() == null || this.getEndWith() == null;
    }

    public static FunctionMetadata metadata() {
        return CommandMetadataResolver.resolve(StartPushStreamingCommand.class);
    }
}

