/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.template;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetlinks.core.command.AbstractConvertCommand;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.sdk.server.template.EntityTemplateInfo;
import org.jetlinks.sdk.server.template.SaveByTemplateResult;
import org.jetlinks.sdk.server.utils.CastUtils;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

@Schema(title="\u6839\u636e\u6a21\u677f\u4fdd\u5b58\u6570\u636e")
public class SaveByTemplateCommand
extends AbstractConvertCommand<Flux<SaveByTemplateResult>, SaveByTemplateCommand> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveByTemplateCommand.class);
    public static final String PARAMETER_KEY = "data";

    public final SaveByTemplateCommand withTemplate(List<EntityTemplateInfo> entityInstances) {
        this.writable().put(PARAMETER_KEY, entityInstances);
        return (SaveByTemplateCommand)this.castSelf();
    }

    @Schema(title="\u6a21\u677f\u6570\u636e")
    public final List<EntityTemplateInfo> getData() {
        return ConverterUtils.convertToList(this.readable().get(PARAMETER_KEY), EntityTemplateInfo::of);
    }

    @Deprecated
    public final List<EntityTemplateInfo> templateList() {
        return this.getData();
    }

    public final <E> List<E> templateList(Function<EntityTemplateInfo, E> converter) {
        return ConverterUtils.convertToList(this.readable().get(PARAMETER_KEY), f -> converter.apply(EntityTemplateInfo.of(f)));
    }

    @Schema(title="\u662f\u5426\u629b\u51fa\u9519\u8bef")
    public boolean isThrowError() {
        return CastUtils.castBoolean(this.readable().getOrDefault("throwError", true));
    }

    public SaveByTemplateCommand setThrowError(boolean throwError) {
        return (SaveByTemplateCommand)this.with("throwError", throwError);
    }

    public static CommandHandler<SaveByTemplateCommand, Flux<SaveByTemplateResult>> createHandler(Function<SaveByTemplateCommand, Flux<SaveByTemplateResult>> handler) {
        return CommandHandler.of(() -> {
            SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
            metadata.setId(CommandUtils.getCommandIdByType(SaveByTemplateCommand.class));
            metadata.setName("\u6839\u636e\u6a21\u677f\u4fdd\u5b58\u6570\u636e");
            metadata.setInputs(Arrays.asList(SimplePropertyMetadata.of((String)PARAMETER_KEY, (String)"\u6a21\u677f\u6570\u636e", (DataType)EntityTemplateInfo.parseMetadata()), SimplePropertyMetadata.of((String)"throwError", (String)"\u629b\u51fa\u9519\u8bef", (DataType)BooleanType.GLOBAL)));
            metadata.setOutput((DataType)new ObjectType().addProperty("id", "id", (DataType)StringType.GLOBAL).addProperty("success", "\u662f\u5426\u6210\u529f", (DataType)BooleanType.GLOBAL).addProperty("errorMessage", "\u9519\u8bef\u4fe1\u606f", (DataType)StringType.GLOBAL).addProperty(PARAMETER_KEY, PARAMETER_KEY, (DataType)new ObjectType()));
            return metadata;
        }, (cmd, ignore) -> (Flux)handler.apply((SaveByTemplateCommand)((Object)cmd)), SaveByTemplateCommand::new);
    }

    public <T> Flux<SaveByTemplateResult> execute(Function<EntityTemplateInfo, Mono<T>> converter, Function<Flux<DataContext<T>>, Mono<Void>> handler) {
        return this.execute(converter, handler, Queues.SMALL_BUFFER_SIZE);
    }

    public <T> Flux<SaveByTemplateResult> execute(Function<EntityTemplateInfo, Mono<T>> converter, Function<Flux<DataContext<T>>, Mono<Void>> handler, int converterParallel) {
        return (Flux)Flux.fromIterable(this.getData()).flatMap(info -> ((Mono)converter.apply((EntityTemplateInfo)info)).map(data -> DataContext.simple(info, data)).onErrorResume(error -> {
            if (this.isThrowError()) {
                return Mono.error((Throwable)error);
            }
            DataContext<Object> errContext = DataContext.simple(info, null);
            errContext.error((Throwable)error);
            log.warn("converter data by template fail", error);
            return Mono.just(errContext);
        }), converterParallel).as(flux -> {
            Flux cache = flux.cache();
            return ((Mono)handler.apply(cache.filter(c -> c.getData() != null))).onErrorResume(err -> {
                if (this.isThrowError()) {
                    return Mono.error((Throwable)err);
                }
                return cache.doOnNext(d -> d.error((Throwable)err)).then(Mono.empty());
            }).thenMany((Publisher)cache.map(DataContext::toResult));
        });
    }

    public static interface DataContext<T> {
        public T getData();

        public void success();

        public void error(Throwable var1);

        public void error(String var1);

        public SaveByTemplateResult toResult();

        public static <D> DataContext<D> simple(EntityTemplateInfo info, D data) {
            return new SimpleDataContext<D>(info, data);
        }
    }

    static class SimpleDataContext<T>
    implements DataContext<T> {
        @Nullable
        private T data;
        private EntityTemplateInfo info;
        private boolean success = true;
        private String errorMessage;

        public SimpleDataContext(EntityTemplateInfo info, @Nullable T data) {
            this.info = info;
            this.data = data;
        }

        @Override
        public void success() {
            this.success = true;
        }

        @Override
        public void error(Throwable error) {
            this.success = false;
            this.errorMessage = error.getLocalizedMessage();
        }

        @Override
        public void error(String message) {
            this.success = false;
            this.errorMessage = message;
        }

        @Override
        public SaveByTemplateResult toResult() {
            SaveByTemplateResult response = SaveByTemplateResult.of(this.info);
            response.setDate(this.data);
            response.setSuccess(this.success);
            response.setErrorMessage(this.errorMessage);
            return response;
        }

        @Override
        @Nullable
        @Generated
        public T getData() {
            return this.data;
        }

        @Generated
        public EntityTemplateInfo getInfo() {
            return this.info;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public void setData(@Nullable T data) {
            this.data = data;
        }

        @Generated
        public void setInfo(EntityTemplateInfo info) {
            this.info = info;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

