/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.template;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import lombok.Generated;
import org.jetlinks.core.utils.ConverterUtils;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.template.EntityTemplateInfo;

public class SaveByTemplateResult
implements Externalizable {
    @Schema(title="\u8d44\u6e90id")
    private String id;
    @Schema(description="\u5b9e\u4f53ID")
    private String targetId;
    @Schema(description="\u5b9e\u4f53\u7c7b\u522b")
    private String targetType;
    @Schema(title="\u662f\u5426\u6210\u529f")
    private boolean success;
    @Schema(title="\u6570\u636e")
    private Object date;
    @Schema(title="\u9519\u8bef\u4fe1\u606f")
    private String errorMessage;

    public static SaveByTemplateResult success(EntityTemplateInfo info, Object date) {
        SaveByTemplateResult data = SaveByTemplateResult.of(info);
        data.setSuccess(true);
        data.setDate(date);
        return data;
    }

    public static SaveByTemplateResult error(EntityTemplateInfo info, String errorMessage) {
        SaveByTemplateResult data = SaveByTemplateResult.of(info);
        data.setSuccess(false);
        data.setErrorMessage(errorMessage);
        return data;
    }

    public static SaveByTemplateResult of(EntityTemplateInfo info) {
        SaveByTemplateResult data = new SaveByTemplateResult();
        data.setId(info.getId());
        data.setTargetId(info.getTargetId());
        data.setTargetType(info.getTargetType());
        return data;
    }

    public <T> T dateTo(Class<T> clazz) {
        return (T)ConverterUtils.convert((Object)this.date, clazz);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        SerializeUtils.writeNullableUTF((String)this.targetId, (ObjectOutput)out);
        out.writeUTF(this.targetType);
        out.writeBoolean(this.success);
        SerializeUtils.writeNullableUTF((String)this.errorMessage, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)SerializeUtils.convertToSafelySerializable((Object)this.date), (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.targetId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.targetType = in.readUTF();
        this.success = in.readBoolean();
        this.errorMessage = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.date = SerializeUtils.readObject((ObjectInput)in);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTargetId() {
        return this.targetId;
    }

    @Generated
    public String getTargetType() {
        return this.targetType;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public Object getDate() {
        return this.date;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Generated
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setDate(Object date) {
        this.date = date;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

