/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.sdk.server.utils.ObjectMappers;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;

public class ConverterUtils {
    static final ObjectReader termReader = ObjectMappers.JSON_MAPPER.readerForListOf(Term.class);

    public static Object tryConvertToList(Object value, Function<Object, Object> converter) {
        return org.jetlinks.core.utils.ConverterUtils.tryConvertToList((Object)value, converter);
    }

    public static <T> List<T> convertToList(Object value, Function<Object, T> converter) {
        return org.jetlinks.core.utils.ConverterUtils.convertToList((Object)value, converter);
    }

    public static List<Object> convertToList(Object value) {
        return ConverterUtils.convertToList(value, Function.identity());
    }

    public static String[] convertMapToTags(Map<String, Object> map) {
        return org.jetlinks.core.utils.ConverterUtils.convertMapToTags(map);
    }

    public static List<Term> convertTerms(Object value) {
        if (value instanceof String) {
            String strVal = String.valueOf(value);
            if (strVal.startsWith("[")) {
                return (List)termReader.readValue(strVal);
            }
            if (strVal.startsWith("{")) {
                return TermExpressionParser.parse((Map)ObjectMappers.parseJson(strVal, Map.class));
            }
            return TermExpressionParser.parse((String)strVal);
        }
        if (value instanceof List) {
            return ((List)value).stream().map(obj -> obj instanceof Term ? (Term)obj : (Term)FastBeanCopier.copy((Object)obj, (Object)new Term(), (String[])new String[0])).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            return TermExpressionParser.parse((Map)((Map)value));
        }
        throw new UnsupportedOperationException("unsupported term value:" + value);
    }

    public static DataBuffer convertDataBuffer(Object obj) {
        return org.jetlinks.core.utils.ConverterUtils.convertDataBuffer((Object)obj);
    }

    public static <T> ByteBuf convertNettyBuffer(T obj, Function<T, ByteBuf> fallback) {
        return org.jetlinks.core.utils.ConverterUtils.convertNettyBuffer(obj, fallback);
    }

    public static ByteBuf convertNettyBuffer(Object obj) {
        return org.jetlinks.core.utils.ConverterUtils.convertNettyBuffer((Object)obj);
    }

    public static HttpHeaders convertHttpHeaders(Object headers) {
        return org.jetlinks.core.utils.ConverterUtils.convertHttpHeaders((Object)headers);
    }
}

