/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.jersey.client.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import org.sonatype.spice.jersey.client.ahc.AhcRequestWriter;
import org.sonatype.spice.jersey.client.ahc.config.AhcConfig;
import org.sonatype.spice.jersey.client.ahc.config.DefaultAhcConfig;

public final class AhcClientHandler
implements ClientHandler {
    private final AsyncHttpClient client;
    private final AhcConfig config;
    private final AhcRequestWriter requestWriter = new AhcRequestWriter();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    @Context
    private MessageBodyWorkers workers;

    public AhcClientHandler(AsyncHttpClient client) {
        this(client, new DefaultAhcConfig());
    }

    public AhcClientHandler(AsyncHttpClient client, AhcConfig config) {
        this.client = client;
        this.config = config;
    }

    public AhcConfig getConfig() {
        return this.config;
    }

    public AsyncHttpClient getHttpClient() {
        return this.client;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        try {
            RequestBuilder requestBuilder = this.getRequestBuilder(cr);
            this.handleCookie(requestBuilder);
            this.requestWriter.configureRequest(requestBuilder, cr, this.allowBody(cr.getMethod()));
            Response response = (Response)this.client.executeRequest(requestBuilder.build()).get();
            this.applyResponseCookies(response.getCookies());
            ClientResponse r = new ClientResponse(response.getStatusCode(), this.getInBoundHeaders(response), response.getResponseBodyAsStream(), this.workers);
            if (!r.hasEntity()) {
                r.bufferEntity();
                r.close();
            }
            return r;
        }
        catch (Exception e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    private void applyResponseCookies(List<Cookie> responseCookies) {
        if (responseCookies != null) {
            for (Cookie rc : responseCookies) {
                Iterator<Cookie> it = this.cookies.iterator();
                while (it.hasNext()) {
                    Cookie c = it.next();
                    if (!this.isSame(rc, c)) continue;
                    it.remove();
                    break;
                }
                this.cookies.add(rc);
            }
        }
    }

    private boolean isSame(Cookie c, Cookie o) {
        return this.isEquals(c.getDomain(), o.getDomain()) && this.isEquals(c.getPath(), o.getPath()) && this.isEquals(c.getName(), o.getName());
    }

    private boolean isEquals(Object o, Object o2) {
        return o == null && o2 == null || o != null && o.equals(o2);
    }

    private boolean allowBody(String method) {
        return !method.equalsIgnoreCase("GET") && (!method.equalsIgnoreCase("OPTIONS") || !method.equalsIgnoreCase("TRACE") || !method.equalsIgnoreCase("HEAD"));
    }

    private RequestBuilder getRequestBuilder(ClientRequest cr) {
        String strMethod = cr.getMethod();
        String uri = cr.getURI().toString();
        if (strMethod.equals("GET")) {
            return new RequestBuilder("GET").setUrl(uri);
        }
        if (strMethod.equals("POST")) {
            return new RequestBuilder("POST").setUrl(uri);
        }
        if (strMethod.equals("PUT")) {
            return new RequestBuilder("PUT").setUrl(uri);
        }
        if (strMethod.equals("DELETE")) {
            return new RequestBuilder("DELETE").setUrl(uri);
        }
        if (strMethod.equals("HEAD")) {
            return new RequestBuilder("HEAD").setUrl(uri);
        }
        if (strMethod.equals("OPTIONS")) {
            return new RequestBuilder("OPTIONS").setUrl(uri);
        }
        return new RequestBuilder(strMethod).setUrl(uri);
    }

    private InBoundHeaders getInBoundHeaders(Response response) {
        InBoundHeaders headers = new InBoundHeaders();
        FluentCaseInsensitiveStringsMap respHeaders = response.getHeaders();
        for (Map.Entry header : respHeaders) {
            headers.put(header.getKey(), header.getValue());
        }
        return headers;
    }

    public AhcRequestWriter getAhcRequestWriter() {
        return this.requestWriter;
    }

    private void handleCookie(RequestBuilder requestBuilder) {
        for (Cookie c : this.cookies) {
            requestBuilder.addCookie(c);
        }
    }
}

