/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.jersey.client.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import org.sonatype.spice.jersey.client.ahc.AhcClientHandler;
import org.sonatype.spice.jersey.client.ahc.config.AhcConfig;
import org.sonatype.spice.jersey.client.ahc.config.DefaultAhcConfig;

public class AhcHttpClient
extends Client {
    private final AhcClientHandler clientHandler;

    public AhcHttpClient() {
        this(AhcHttpClient.createDefaultClientHander(new DefaultAhcConfig()));
    }

    public AhcHttpClient(AhcClientHandler root) {
        this(root, null);
    }

    @Deprecated
    public AhcHttpClient(AhcClientHandler root, ClientConfig config, IoCComponentProviderFactory provider) {
        this(root, provider);
    }

    public AhcHttpClient(AhcClientHandler root, IoCComponentProviderFactory provider) {
        super((ClientHandler)root, (ClientConfig)root.getConfig(), provider);
        this.clientHandler = root;
        this.inject((Object)this.clientHandler.getAhcRequestWriter());
    }

    public AhcClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public static AhcHttpClient create() {
        return AhcHttpClient.create(new DefaultAhcConfig());
    }

    public static AhcHttpClient create(ClientConfig cc) {
        return AhcHttpClient.create(cc, null);
    }

    public static AhcHttpClient create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new AhcHttpClient(AhcHttpClient.createDefaultClientHander(cc), provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.clientHandler.getHttpClient().close();
        }
        finally {
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            super.destroy();
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
        }
    }

    private static AhcClientHandler createDefaultClientHander(ClientConfig cc) {
        if (AhcConfig.class.isAssignableFrom(cc.getClass()) || DefaultAhcConfig.class.isAssignableFrom(cc.getClass())) {
            AhcConfig c = (AhcConfig)AhcConfig.class.cast(cc);
            return new AhcClientHandler(new AsyncHttpClient(c.getAsyncHttpClientConfigBuilder().build()), c);
        }
        throw new IllegalStateException("Client Config Type not supported");
    }

    public void setFollowRedirects(Boolean redirect) {
        this.clientHandler.getConfig().getAsyncHttpClientConfigBuilder().setFollowRedirects(redirect.booleanValue());
    }

    public void setReadTimeout(Integer interval) {
        this.clientHandler.getConfig().getAsyncHttpClientConfigBuilder().setRequestTimeoutInMs(interval.intValue());
    }

    public void setConnectTimeout(Integer interval) {
        this.clientHandler.getConfig().getAsyncHttpClientConfigBuilder().setConnectionTimeoutInMs(interval.intValue());
    }
}

