/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.jersey.client.ahc;

import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.CommittingOutputStream;
import com.sun.jersey.api.client.RequestWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class AhcRequestWriter
extends RequestWriter {
    public void configureRequest(final RequestBuilder requestBuilder, final ClientRequest cr, boolean needsBody) {
        Map props = cr.getProperties();
        Integer readTimeout = (Integer)props.get("com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            PerRequestConfig c = new PerRequestConfig();
            c.setRequestTimeoutInMs(readTimeout.intValue());
            requestBuilder.setPerRequestConfig(c);
        }
        if (cr.getEntity() != null && needsBody) {
            RequestWriter.RequestEntityWriter re = this.getRequestEntityWriter(cr);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                re.writeRequestEntity((OutputStream)new CommittingOutputStream(baos){

                    protected void commit() throws IOException {
                        AhcRequestWriter.this.configureHeaders((MultivaluedMap<String, Object>)cr.getHeaders(), requestBuilder);
                    }
                });
            }
            catch (IOException ex) {
                throw new ClientHandlerException((Throwable)ex);
            }
            final byte[] content = baos.toByteArray();
            requestBuilder.setBody(new Request.EntityWriter(){

                public void writeEntity(OutputStream out) throws IOException {
                    out.write(content);
                }
            });
        } else {
            this.configureHeaders((MultivaluedMap<String, Object>)cr.getHeaders(), requestBuilder);
        }
    }

    private void configureHeaders(MultivaluedMap<String, Object> metadata, RequestBuilder requestBuilder) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            for (Object o : vs) {
                if (String.class.isAssignableFrom(o.getClass())) {
                    requestBuilder.addHeader((String)e.getKey(), o.toString());
                    continue;
                }
                requestBuilder.addHeader((String)e.getKey(), ClientRequest.getHeaderValue(o));
            }
        }
    }
}

