/*
 * Copyright 2014 mango.jfaster.org
 *
 * The Mango Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.jfaster.mango.operator;

import org.jfaster.mango.reflect.Parameter;
import org.jfaster.mango.util.SQLType;

import java.util.List;

/**
 * @author ash
 */
public abstract class UpdateInterceptor implements Interceptor {

    @Override
    public void intercept(PreparedSql preparedSql, List<Parameter> parameters, SQLType sqlType) {
        if (sqlType.needChangeData()) {
            interceptUpdate(preparedSql, parameters, sqlType);
        }
    }

    public abstract void interceptUpdate(PreparedSql preparedSql, List<Parameter> parameters, SQLType sqlType);

}
