/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;

public class DataSourceMonitor {
    private static final ConcurrentHashMap<DataSource, AtomicInteger> map = new ConcurrentHashMap();
    private static volatile boolean forceCheckAutoCommit = false;

    public static boolean needCheckAutoCommit(DataSource ds) {
        return forceCheckAutoCommit || map.get(ds) != null;
    }

    public static void resetAutoCommitFail(DataSource ds) {
        AtomicInteger old;
        AtomicInteger val = map.get(ds);
        if (val == null && (old = map.putIfAbsent(ds, val = new AtomicInteger())) != null) {
            val = old;
        }
        val.incrementAndGet();
    }

    public static void setForceCheckAutoCommit(boolean forceCheckAutoCommit) {
        DataSourceMonitor.forceCheckAutoCommit = forceCheckAutoCommit;
    }

    public static Map<DataSource, Integer> getFailedDataSources() {
        HashMap<DataSource, Integer> dsMap = new HashMap<DataSource, Integer>();
        for (Map.Entry<DataSource, AtomicInteger> entry : map.entrySet()) {
            dsMap.put(entry.getKey(), entry.getValue().intValue());
        }
        return dsMap;
    }
}

