/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceMonitor;
import org.jfaster.mango.exception.jdbc.CannotGetJdbcConnectionException;
import org.jfaster.mango.transaction.ConnectionHolder;
import org.jfaster.mango.transaction.TransactionSynchronizationManager;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class DataSourceUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DataSourceUtils.class);

    public static Connection getConnection(DataSource dataSource) throws CannotGetJdbcConnectionException {
        try {
            return DataSourceUtils.doGetConnection(dataSource);
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
        }
    }

    private static Connection doGetConnection(DataSource dataSource) throws SQLException {
        ConnectionHolder connHolder = TransactionSynchronizationManager.getConnectionHolder(dataSource);
        if (connHolder != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Fetching resumed JDBC Connection from DataSource");
            }
            return connHolder.getConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Fetching JDBC Connection from DataSource");
        }
        Connection conn = dataSource.getConnection();
        if (DataSourceMonitor.needCheckAutoCommit(dataSource)) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                logger.error("Could not set autoCommit of JDBC Connection after get Connection, so close it");
                DataSourceUtils.releaseConnection(conn, dataSource);
                throw new CannotGetJdbcConnectionException("Could not set autoCommit of JDBC Connection after get Connection, so close it");
            }
        }
        return conn;
    }

    public static void releaseConnection(@Nullable Connection conn, DataSource dataSource) {
        try {
            DataSourceUtils.doReleaseConnection(conn, dataSource);
        }
        catch (SQLException e) {
            logger.error("Could not close JDBC Connection", e);
        }
        catch (Throwable e) {
            logger.error("Unexpected exception on closing JDBC Connection", e);
        }
    }

    private static void doReleaseConnection(@Nullable Connection conn, DataSource dataSource) throws SQLException {
        if (conn == null) {
            return;
        }
        ConnectionHolder connHolder = TransactionSynchronizationManager.getConnectionHolder(dataSource);
        if (connHolder != null && DataSourceUtils.connectionEquals(connHolder, conn)) {
            return;
        }
        logger.debug("Returning JDBC Connection to DataSource");
        conn.close();
    }

    private static boolean connectionEquals(ConnectionHolder connHolder, Connection passedInConn) {
        Connection heldConn = connHolder.getConnection();
        return heldConn == passedInConn || heldConn.equals(passedInConn);
    }
}

