/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.datasource;

import java.util.List;
import java.util.Random;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceType;

public class MasterSlaveDataSourceFactory
implements DataSourceFactory {
    private DataSource master;
    private List<DataSource> slaves;
    private final Random random = new Random();

    public MasterSlaveDataSourceFactory() {
    }

    public MasterSlaveDataSourceFactory(DataSource master, List<DataSource> slaves) {
        this.master = master;
        this.slaves = slaves;
    }

    @Override
    public DataSource getDataSource(String name, DataSourceType dataSourceType) {
        return dataSourceType == DataSourceType.MASTER ? this.master : this.slaves.get(this.random.nextInt(this.slaves.size()));
    }

    public DataSource getMaster() {
        return this.master;
    }

    public void setMaster(DataSource master) {
        this.master = master;
    }

    public List<DataSource> getSlaves() {
        return this.slaves;
    }

    public void setSlaves(List<DataSource> slaves) {
        this.slaves = slaves;
    }
}

