/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.datasource;

import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceType;

public class MultipleDataSourceFactory
implements DataSourceFactory {
    private Map<String, DataSourceFactory> factories;

    public MultipleDataSourceFactory() {
    }

    public MultipleDataSourceFactory(Map<String, DataSourceFactory> factories) {
        this.factories = factories;
    }

    @Override
    public DataSource getDataSource(String name, DataSourceType dataSourceType) {
        DataSourceFactory factory = this.factories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("can not find the data source factory by name [" + name + "], " + "available data sources name is " + this.factories.keySet());
        }
        return factory.getDataSource(name, dataSourceType);
    }

    public Map<String, DataSourceFactory> getFactories() {
        return this.factories;
    }

    public void setFactories(Map<String, DataSourceFactory> factories) {
        this.factories = factories;
    }
}

