/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.exception.NotReadablePropertyException;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.reflect.TypeToken;
import org.jfaster.mango.util.Strings;

public class FunctionalGetterInvokerGroup
implements GetterInvokerGroup {
    private final Type finalType;
    private final String parameterName;
    private String propertyPath;
    private final List<GetterInvoker> invokers;

    private FunctionalGetterInvokerGroup(Type type, String parameterName, String propertyPath) {
        this.parameterName = parameterName;
        this.propertyPath = propertyPath;
        this.invokers = new ArrayList<GetterInvoker>();
        Class<?> rawType = TypeToken.of(type).getRawType();
        if (Strings.isNotEmpty(propertyPath)) {
            NestedProperty np = new NestedProperty();
            NestedProperty pnp = new NestedProperty();
            for (String propertyName : propertyPath.split("\\.")) {
                np.append(propertyName);
                GetterInvoker invoker = InvokerCache.getGetterInvoker(rawType, propertyName);
                if (invoker == null) {
                    String fullName = Strings.getFullName(parameterName, np.getNestedProperty());
                    String pFullName = Strings.getFullName(parameterName, pnp.getNestedProperty());
                    throw new NotReadablePropertyException("property " + fullName + " is not readable, " + "the type of " + pFullName + " is " + type + ", please check it's get method");
                }
                this.invokers.add(invoker);
                type = invoker.getReturnType();
                rawType = TypeToken.of(type).getRawType();
                pnp.append(propertyName);
            }
        }
        this.finalType = type;
    }

    public static FunctionalGetterInvokerGroup create(Type type, String parameterName, String propertyPath) {
        return new FunctionalGetterInvokerGroup(type, parameterName, propertyPath);
    }

    @Override
    public Type getFinalType() {
        return this.finalType;
    }

    @Override
    public Object invoke(Object obj) {
        Object r = obj;
        int size = this.invokers.size();
        for (int i = 0; i < size; ++i) {
            if (r == null) {
                NestedProperty np = new NestedProperty();
                for (int j = 0; j < i; ++j) {
                    np.append(this.invokers.get(i).getName());
                }
                String key = i == 0 ? "parameter" : "property";
                String fullName = Strings.getFullName(this.parameterName, np.getNestedProperty());
                throw new NullPointerException(key + " " + fullName + " is null");
            }
            r = this.invokers.get(i).invoke(r);
        }
        return r;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    private static class NestedProperty {
        private StringBuilder nestedProperty = new StringBuilder();
        private int num = 0;

        private NestedProperty() {
        }

        public void append(String property) {
            if (this.num++ == 0) {
                this.nestedProperty.append(property);
            } else {
                this.nestedProperty.append("." + property);
            }
        }

        public String getNestedProperty() {
            return this.nestedProperty.toString();
        }
    }
}

