/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Getter;
import org.jfaster.mango.annotation.Setter;
import org.jfaster.mango.exception.IncorrectGetterAnnotationException;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.invoker.MethodNamedObject;
import org.jfaster.mango.invoker.SetterFunction;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.reflect.TypeToken;
import org.jfaster.mango.reflect.Types;

public class FunctionalSetterInvoker
extends MethodNamedObject
implements SetterInvoker {
    private SetterFunction function;
    private Type parameterType;
    private Class<?> parameterRawType;
    private Type runtimeOutputType;
    private Class<?> runtimeOutputRawType;

    private FunctionalSetterInvoker(String name, Method method) {
        super(name, method);
        TypeToken<?> parameterToken = TypeToken.of(method.getGenericParameterTypes()[0]);
        this.runtimeOutputType = parameterToken.getType();
        this.runtimeOutputRawType = parameterToken.getRawType();
        Getter getterAnno = method.getAnnotation(Getter.class);
        if (getterAnno != null) {
            throw new IncorrectGetterAnnotationException("@Getter annotation can not be placed on the set method [" + method + "]");
        }
        Setter setterAnno = method.getAnnotation(Setter.class);
        if (setterAnno != null) {
            Class<SetterFunction<?, ?>> funcClass = setterAnno.value();
            this.function = Reflection.instantiate(funcClass);
            Type genType = funcClass.getGenericSuperclass();
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            TypeToken<?> inputToken = TypeToken.of(params[0]);
            TypeToken<?> outputToken = TypeToken.of(params[1]);
            TypeToken<?> wrapParameterToken = parameterToken.wrap();
            if (this.function.outputTypeIsGeneric()) {
                if (!outputToken.isAssignableFrom(wrapParameterToken)) {
                    throw new ClassCastException("function[" + this.function.getClass() + "] " + "on method[" + method + "] error, function's outputType[" + outputToken.getType() + "] " + "must be assignable from method's parameterType[" + parameterToken.getType() + "]");
                }
            } else if (!wrapParameterToken.isAssignableFrom(outputToken)) {
                throw new ClassCastException("function[" + this.function.getClass() + "] " + "on method[" + method + "] error, method's parameterType[" + parameterToken.getType() + "] " + "must be assignable from function's outputType[" + outputToken.getType() + "]");
            }
            parameterToken = inputToken;
        }
        this.parameterType = parameterToken.getType();
        this.parameterRawType = parameterToken.getRawType();
    }

    public static FunctionalSetterInvoker create(String name, Method method) {
        return new FunctionalSetterInvoker(name, method);
    }

    @Override
    public void invoke(Object object, @Nullable Object parameter) {
        try {
            if (this.function != null) {
                parameter = this.function.apply(parameter, this.runtimeOutputType);
            }
            if (parameter == null && this.runtimeOutputRawType.isPrimitive()) {
                throw new NullPointerException("property " + this.getName() + " of " + object.getClass() + " is primitive, can not be assigned to null");
            }
            if (parameter != null && !Types.isAssignable(this.runtimeOutputRawType, parameter.getClass())) {
                throw new ClassCastException("cannot convert value of type [" + parameter.getClass().getName() + "] to required type [" + this.runtimeOutputRawType.getName() + "] " + "for property '" + this.getName() + "' of " + object.getClass());
            }
            this.method.invoke(object, parameter);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Type getParameterType() {
        return this.parameterType;
    }

    @Override
    public Class<?> getParameterRawType() {
        return this.parameterRawType;
    }
}

