/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.invoker.FunctionalGetterInvoker;
import org.jfaster.mango.invoker.FunctionalSetterInvoker;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.util.concurrent.cache.CacheLoader;
import org.jfaster.mango.util.concurrent.cache.DoubleCheckCache;
import org.jfaster.mango.util.concurrent.cache.LoadingCache;

public class InvokerCache {
    private static final LoadingCache<Class<?>, BeanInfo> cache = new DoubleCheckCache(new CacheLoader<Class<?>, BeanInfo>(){

        @Override
        public BeanInfo load(Class<?> clazz) {
            try {
                return new BeanInfo(clazz);
            }
            catch (Exception e) {
                throw new UncheckedException(e.getMessage(), e);
            }
        }
    });

    @Nullable
    public static GetterInvoker getGetterInvoker(Class<?> clazz, String propertyName) {
        return cache.get(clazz).getGetterInvoker(propertyName);
    }

    public static List<GetterInvoker> getGetterInvokers(Class<?> clazz) {
        return InvokerCache.cache.get(clazz).getGetterInvokers();
    }

    public static List<SetterInvoker> getSetterInvokers(Class<?> clazz) {
        return InvokerCache.cache.get(clazz).getSetterInvokers();
    }

    private static class BeanInfo {
        private final Map<String, GetterInvoker> getterInvokerMap;
        private final Map<String, SetterInvoker> setterInvokerMap;
        private final List<GetterInvoker> getterInvokers;
        private final List<SetterInvoker> setterInvokers;

        public BeanInfo(Class<?> clazz) throws Exception {
            HashMap<String, FunctionalGetterInvoker> gim = new HashMap<String, FunctionalGetterInvoker>();
            HashMap<String, FunctionalSetterInvoker> sim = new HashMap<String, FunctionalSetterInvoker>();
            ArrayList<FunctionalGetterInvoker> gis = new ArrayList<FunctionalGetterInvoker>();
            ArrayList<FunctionalSetterInvoker> sis = new ArrayList<FunctionalSetterInvoker>();
            java.beans.BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method writeMethod;
                if (Class.class.equals(pd.getPropertyType())) continue;
                String name = pd.getName();
                String bname = BeanInfo.isBoolean(pd.getPropertyType()) ? "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length()) : null;
                Method readMethod = pd.getReadMethod();
                if (readMethod != null) {
                    FunctionalGetterInvoker fgi = FunctionalGetterInvoker.create(name, readMethod);
                    gim.put(name, fgi);
                    gis.add(fgi);
                    if (bname != null) {
                        FunctionalGetterInvoker bfgi = FunctionalGetterInvoker.create(bname, readMethod);
                        gim.put(bname, bfgi);
                        gis.add(bfgi);
                    }
                }
                if ((writeMethod = pd.getWriteMethod()) == null) continue;
                FunctionalSetterInvoker fsi = FunctionalSetterInvoker.create(name, writeMethod);
                sim.put(name, fsi);
                sis.add(fsi);
                if (bname == null) continue;
                FunctionalSetterInvoker bfsi = FunctionalSetterInvoker.create(bname, writeMethod);
                sim.put(bname, bfsi);
                sis.add(bfsi);
            }
            this.getterInvokerMap = Collections.unmodifiableMap(gim);
            this.setterInvokerMap = Collections.unmodifiableMap(sim);
            this.getterInvokers = Collections.unmodifiableList(gis);
            this.setterInvokers = Collections.unmodifiableList(sis);
        }

        GetterInvoker getGetterInvoker(String propertyName) {
            return this.getterInvokerMap.get(propertyName);
        }

        SetterInvoker getSetterInvoker(String propertyName) {
            return this.setterInvokerMap.get(propertyName);
        }

        private List<GetterInvoker> getGetterInvokers() {
            return this.getterInvokers;
        }

        private List<SetterInvoker> getSetterInvokers() {
            return this.setterInvokers;
        }

        private static boolean isBoolean(Class<?> clazz) {
            return Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
        }
    }
}

