/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.SQLException;
import org.jfaster.mango.exception.jdbc.DataAccessException;
import org.jfaster.mango.exception.jdbc.UncategorizedSQLException;
import org.jfaster.mango.jdbc.SQLExceptionTranslator;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public abstract class AbstractFallbackSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractFallbackSQLExceptionTranslator.class);
    private SQLExceptionTranslator fallbackTranslator;

    @Override
    public DataAccessException translate(String sql, SQLException ex) {
        DataAccessException dex = this.doTranslate(sql, ex);
        if (dex != null) {
            return dex;
        }
        SQLExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null) {
            return fallback.translate(sql, ex);
        }
        return new UncategorizedSQLException(sql, ex);
    }

    protected abstract DataAccessException doTranslate(String var1, SQLException var2);

    protected String buildMessage(String sql, SQLException ex) {
        return "SQL [" + sql + "]; " + ex.getMessage();
    }

    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    public void setFallbackTranslator(SQLExceptionTranslator fallbackTranslator) {
        this.fallbackTranslator = fallbackTranslator;
    }
}

