/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.jdbc.RowMapper;
import org.jfaster.mango.util.Arrays;

public class ArrayResultSetExtractor<T>
implements ResultSetExtractor<Object> {
    private final RowMapper<T> rowMapper;

    public ArrayResultSetExtractor(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public Object extractData(ResultSet rs) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        int rowNum = 0;
        while (rs.next()) {
            list.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return Arrays.toArray(list, this.rowMapper.getMappedClass());
    }
}

