/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.jdbc.JdbcUtils;
import org.jfaster.mango.jdbc.RowMapper;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BeanPropertyRowMapper.class);
    private Class<T> mappedClass;
    private Map<String, SetterInvoker> invokerMap;

    public BeanPropertyRowMapper(Class<T> mappedClass, Map<String, String> propertyToColumnMap) {
        this.initialize(mappedClass, propertyToColumnMap);
    }

    protected void initialize(Class<T> mappedClass, Map<String, String> propertyToColumnMap) {
        this.mappedClass = mappedClass;
        this.invokerMap = new HashMap<String, SetterInvoker>();
        List<SetterInvoker> invokers = InvokerCache.getSetterInvokers(mappedClass);
        for (SetterInvoker invoker : invokers) {
            String column = propertyToColumnMap.get(invoker.getName().toLowerCase());
            if (column != null) {
                this.invokerMap.put(column, invoker);
                continue;
            }
            this.invokerMap.put(invoker.getName().toLowerCase(), invoker);
            String underscoredName = Strings.underscoreName(invoker.getName());
            if (invoker.getName().toLowerCase().equals(underscoredName)) continue;
            this.invokerMap.put(underscoredName, invoker);
        }
    }

    @Override
    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        T mappedObject = Reflection.instantiate(this.mappedClass);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName(rsmd, index);
            SetterInvoker invoker = this.invokerMap.get(column.trim().toLowerCase());
            if (invoker == null) continue;
            Object value = JdbcUtils.getResultSetValue(rs, index, invoker.getParameterRawType());
            if (logger.isDebugEnabled() && rowNumber == 0) {
                logger.debug("Mapping column '" + column + "' to property '" + invoker.getName() + "' of type " + invoker.getParameterRawType());
            }
            invoker.invoke(mappedObject, value);
        }
        return mappedObject;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }
}

