/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceUtils;
import org.jfaster.mango.exception.jdbc.DataAccessException;
import org.jfaster.mango.exception.jdbc.DataRetrievalFailureException;
import org.jfaster.mango.jdbc.ArrayResultSetExtractor;
import org.jfaster.mango.jdbc.GeneratedKeyHolder;
import org.jfaster.mango.jdbc.JdbcOperations;
import org.jfaster.mango.jdbc.JdbcUtils;
import org.jfaster.mango.jdbc.ListResultSetExtractor;
import org.jfaster.mango.jdbc.ListSupplier;
import org.jfaster.mango.jdbc.ObjectResultSetExtractor;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.jdbc.RowMapper;
import org.jfaster.mango.jdbc.SQLErrorCodeSQLExceptionTranslator;
import org.jfaster.mango.jdbc.SQLExceptionTranslator;
import org.jfaster.mango.jdbc.SetResultSetExtractor;
import org.jfaster.mango.util.concurrent.cache.CacheLoader;
import org.jfaster.mango.util.concurrent.cache.DoubleCheckCache;
import org.jfaster.mango.util.concurrent.cache.LoadingCache;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class JdbcTemplate
implements JdbcOperations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdbcTemplate.class);
    private final LoadingCache<DataSource, SQLExceptionTranslator> exceptionTranslatorCache = new DoubleCheckCache<DataSource, SQLExceptionTranslator>(new CacheLoader<DataSource, SQLExceptionTranslator>(){

        @Override
        public SQLExceptionTranslator load(DataSource dataSource) {
            return new SQLErrorCodeSQLExceptionTranslator(dataSource);
        }
    });

    @Override
    public <T> T queryForObject(DataSource dataSource, String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(dataSource, sql, args, new ObjectResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(DataSource dataSource, String sql, Object[] args, ListSupplier listSupplier, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.executeQuery(dataSource, sql, args, new ListResultSetExtractor<T>(listSupplier, rowMapper));
    }

    @Override
    public <T> Set<T> queryForSet(DataSource dataSource, String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return (Set)this.executeQuery(dataSource, sql, args, new SetResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Object queryForArray(DataSource dataSource, String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(dataSource, sql, args, new ArrayResultSetExtractor<T>(rowMapper));
    }

    @Override
    public int update(DataSource dataSource, String sql, Object[] args) throws DataAccessException {
        return this.update(dataSource, sql, args, null);
    }

    @Override
    public int update(DataSource dataSource, String sql, Object[] args, GeneratedKeyHolder holder) throws DataAccessException {
        int n;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block9: {
            SQLException ee;
            block10: {
                conn = DataSourceUtils.getConnection(dataSource);
                ps = null;
                rs = null;
                Integer r = null;
                ee = null;
                try {
                    boolean needGenerateKey = holder != null;
                    ps = needGenerateKey ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
                    this.setValues(ps, args);
                    r = ps.executeUpdate();
                    if (needGenerateKey) {
                        rs = ps.getGeneratedKeys();
                        if (!rs.next()) {
                            throw new DataRetrievalFailureException("Unable to retrieve the generated key. Check that the table has an identity column enabled.");
                        }
                        Object key = JdbcUtils.getResultSetValue(rs, 1, holder.getKeyClass());
                        holder.setKey(key);
                    }
                    n = r;
                    if (!logger.isDebugEnabled()) break block9;
                    if (ee != null) break block10;
                }
                catch (SQLException e) {
                    try {
                        JdbcUtils.closeResultSet(rs);
                        rs = null;
                        JdbcUtils.closeStatement(ps);
                        ps = null;
                        DataSourceUtils.releaseConnection(conn, dataSource);
                        conn = null;
                        ee = e;
                        throw this.getExceptionTranslator(dataSource).translate(sql, e);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            if (ee == null) {
                                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                            } else {
                                logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
                            }
                        }
                        JdbcUtils.closeResultSet(rs);
                        JdbcUtils.closeStatement(ps);
                        DataSourceUtils.releaseConnection(conn, dataSource);
                        throw throwable;
                    }
                }
                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                break block9;
            }
            logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(conn, dataSource);
        return n;
    }

    @Override
    public int[] batchUpdate(DataSource dataSource, String sql, List<Object[]> batchArgs) throws DataAccessException {
        int[] nArray;
        PreparedStatement ps;
        Connection conn;
        block11: {
            ArrayList<List<Object>> debugBatchArgs;
            conn = DataSourceUtils.getConnection(dataSource);
            ps = null;
            int[] r = null;
            SQLException ee = null;
            try {
                ps = conn.prepareStatement(sql);
                this.setBatchValues(ps, batchArgs);
                nArray = r = ps.executeBatch();
                if (!logger.isDebugEnabled()) break block11;
                debugBatchArgs = new ArrayList<List<Object>>(batchArgs.size());
            }
            catch (SQLException e) {
                try {
                    JdbcUtils.closeStatement(ps);
                    ps = null;
                    DataSourceUtils.releaseConnection(conn, dataSource);
                    conn = null;
                    ee = e;
                    throw this.getExceptionTranslator(dataSource).translate(sql, e);
                }
                catch (Throwable throwable) {
                    if (logger.isDebugEnabled()) {
                        ArrayList<List<Object>> debugBatchArgs2 = new ArrayList<List<Object>>(batchArgs.size());
                        for (Object[] batchArg : batchArgs) {
                            debugBatchArgs2.add(Arrays.asList(batchArg));
                        }
                        if (ee == null) {
                            logger.debug("\"{}\" #args={} #result={}", sql, debugBatchArgs2, r);
                        } else {
                            logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, debugBatchArgs2, ee.getMessage());
                        }
                    }
                    JdbcUtils.closeStatement(ps);
                    DataSourceUtils.releaseConnection(conn, dataSource);
                    throw throwable;
                }
            }
            for (Object[] batchArg : batchArgs) {
                debugBatchArgs.add(Arrays.asList(batchArg));
            }
            if (ee == null) {
                logger.debug("\"{}\" #args={} #result={}", sql, debugBatchArgs, r);
            } else {
                logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, debugBatchArgs, ee.getMessage());
            }
        }
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(conn, dataSource);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchUpdate(DataSource dataSource, List<String> sqls, List<Object[]> batchArgs) throws DataAccessException {
        int size = Math.min(sqls.size(), batchArgs.size());
        int[] r = new int[size];
        Connection conn = DataSourceUtils.getConnection(dataSource);
        try {
            for (int i = 0; i < size; ++i) {
                PreparedStatement ps;
                block11: {
                    SQLException ee;
                    Object[] args;
                    String sql;
                    block12: {
                        sql = sqls.get(i);
                        args = batchArgs.get(i);
                        ee = null;
                        ps = null;
                        try {
                            ps = conn.prepareStatement(sql);
                            this.setValues(ps, args);
                            r[i] = ps.executeUpdate();
                            if (!logger.isDebugEnabled()) break block11;
                            if (ee != null) break block12;
                        }
                        catch (SQLException e) {
                            try {
                                JdbcUtils.closeStatement(ps);
                                ps = null;
                                DataSourceUtils.releaseConnection(conn, dataSource);
                                conn = null;
                                ee = e;
                                throw this.getExceptionTranslator(dataSource).translate(sql, e);
                            }
                            catch (Throwable throwable) {
                                if (logger.isDebugEnabled()) {
                                    if (ee == null) {
                                        logger.debug("\"{}\" #args={} #result={}", sql, args, r[i]);
                                    } else {
                                        logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
                                    }
                                }
                                JdbcUtils.closeStatement(ps);
                                throw throwable;
                            }
                        }
                        logger.debug("\"{}\" #args={} #result={}", sql, args, r[i]);
                        break block11;
                    }
                    logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
                }
                JdbcUtils.closeStatement(ps);
            }
        }
        finally {
            DataSourceUtils.releaseConnection(conn, dataSource);
        }
        return r;
    }

    private <T> T executeQuery(DataSource dataSource, String sql, Object[] args, ResultSetExtractor<T> rse) throws DataAccessException {
        T t;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block7: {
            SQLException ee;
            block8: {
                conn = DataSourceUtils.getConnection(dataSource);
                ps = null;
                rs = null;
                T r = null;
                ee = null;
                try {
                    ps = conn.prepareStatement(sql);
                    this.setValues(ps, args);
                    rs = ps.executeQuery();
                    t = r = (T)rse.extractData(rs);
                    if (!logger.isDebugEnabled()) break block7;
                    if (ee != null) break block8;
                }
                catch (SQLException e) {
                    try {
                        JdbcUtils.closeResultSet(rs);
                        rs = null;
                        JdbcUtils.closeStatement(ps);
                        ps = null;
                        DataSourceUtils.releaseConnection(conn, dataSource);
                        conn = null;
                        ee = e;
                        throw this.getExceptionTranslator(dataSource).translate(sql, e);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            if (ee == null) {
                                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                            } else {
                                logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
                            }
                        }
                        JdbcUtils.closeResultSet(rs);
                        JdbcUtils.closeStatement(ps);
                        DataSourceUtils.releaseConnection(conn, dataSource);
                        throw throwable;
                    }
                }
                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                break block7;
            }
            logger.debug("[error] \"{}\" #args={} #errorMsg=[{}]", sql, args, ee.getMessage());
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(conn, dataSource);
        return t;
    }

    private void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        int index = 0;
        for (Object arg : args) {
            JdbcUtils.setParameterValue(ps, ++index, arg);
        }
    }

    private void setBatchValues(PreparedStatement ps, List<Object[]> batchArgs) throws SQLException {
        for (Object[] args : batchArgs) {
            int index = 0;
            for (Object arg : args) {
                JdbcUtils.setParameterValue(ps, ++index, arg);
            }
            ps.addBatch();
        }
    }

    private SQLExceptionTranslator getExceptionTranslator(DataSource dataSource) {
        return this.exceptionTranslatorCache.get(dataSource);
    }
}

