/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceUtils;
import org.jfaster.mango.exception.jdbc.CannotGetJdbcConnectionException;
import org.jfaster.mango.exception.jdbc.MetaDataAccessException;
import org.jfaster.mango.util.Primitives;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class JdbcUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdbcUtils.class);
    private static final Set<Class<?>> singleColumClassSet = new HashSet();

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC Statement", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC Statement", e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC ResultSet", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC ResultSet", e);
            }
        }
    }

    public static Object getResultSetValue(ResultSet rs, int index, @Nullable Class requiredType) throws SQLException {
        Object value;
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index);
        }
        boolean wasNullCheck = false;
        if (String.class.equals((Object)requiredType)) {
            value = rs.getString(index);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals((Object)requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals((Object)requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals((Object)requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals((Object)requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals((Object)requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals((Object)requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals((Object)requiredType) || Number.class.equals((Object)requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else if (byte[].class.equals((Object)requiredType)) {
            value = rs.getBytes(index);
        } else if (Date.class.equals((Object)requiredType)) {
            value = rs.getDate(index);
        } else if (Time.class.equals((Object)requiredType)) {
            value = rs.getTime(index);
        } else if (Timestamp.class.equals((Object)requiredType) || java.util.Date.class.equals((Object)requiredType)) {
            value = rs.getTimestamp(index);
        } else if (BigDecimal.class.equals((Object)requiredType)) {
            value = rs.getBigDecimal(index);
        } else if (Blob.class.equals((Object)requiredType)) {
            value = rs.getBlob(index);
        } else if (Clob.class.equals((Object)requiredType)) {
            value = rs.getClob(index);
        } else if (BigInteger.class.equals((Object)requiredType)) {
            value = rs.getObject(index);
            if (value != null && Long.class.equals(value.getClass())) {
                value = BigInteger.valueOf((Long)value);
            }
        } else {
            value = JdbcUtils.getResultSetValue(rs, index);
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static void setParameterValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value != null && java.util.Date.class.equals(value.getClass())) {
            ps.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        } else {
            ps.setObject(index, value);
        }
    }

    public static boolean isSingleColumnClass(Class clazz) {
        return singleColumClassSet.contains(clazz);
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static String fetchDatabaseProductName(DataSource dataSource) throws MetaDataAccessException {
        Connection conn = null;
        try {
            conn = DataSourceUtils.getConnection(dataSource);
            DatabaseMetaData metaData = conn.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", ex);
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        finally {
            DataSourceUtils.releaseConnection(conn, dataSource);
        }
    }

    static {
        singleColumClassSet.add(String.class);
        singleColumClassSet.add(BigDecimal.class);
        singleColumClassSet.add(BigInteger.class);
        singleColumClassSet.add(java.util.Date.class);
        singleColumClassSet.add(byte[].class);
        singleColumClassSet.add(Date.class);
        singleColumClassSet.add(Time.class);
        singleColumClassSet.add(Timestamp.class);
        singleColumClassSet.add(Blob.class);
        singleColumClassSet.add(Clob.class);
        for (Class<?> type : Primitives.allPrimitiveTypes()) {
            singleColumClassSet.add(type);
        }
        for (Class<?> type : Primitives.allWrapperTypes()) {
            singleColumClassSet.add(type);
        }
    }
}

