/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

public enum SQLErrorCodes {
    EMPTY{

        @Override
        void init() {
        }
    }
    ,
    HSQL{

        @Override
        void init() {
            this.setDatabaseProductName("HSQL Database Engine");
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("-22,-28"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("-104"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("-9"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("-80"));
        }
    }
    ,
    MySQL{

        @Override
        void init() {
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("1054,1064,1146"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("1062"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("630,839,840,893,1169,1215,1216,1217,1364,1451,1452,1557"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("1"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("1205"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("1213"));
        }
    };

    private String[] databaseProductNames = new String[0];
    private boolean useSqlStateForTranslation = false;
    private String[] badSqlGrammarCodes = new String[0];
    private String[] invalidResultSetAccessCodes = new String[0];
    private String[] duplicateKeyCodes = new String[0];
    private String[] dataIntegrityViolationCodes = new String[0];
    private String[] permissionDeniedCodes = new String[0];
    private String[] dataAccessResourceFailureCodes = new String[0];
    private String[] transientDataAccessResourceCodes = new String[0];
    private String[] cannotAcquireLockCodes = new String[0];
    private String[] deadlockLoserCodes = new String[0];
    private String[] cannotSerializeTransactionCodes = new String[0];

    public String getDatabaseProductName() {
        return this.databaseProductNames != null && this.databaseProductNames.length > 0 ? this.databaseProductNames[0] : null;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductNames = new String[]{databaseProductName};
    }

    public String[] getDatabaseProductNames() {
        return this.databaseProductNames;
    }

    public void setDatabaseProductNames(String[] databaseProductNames) {
        this.databaseProductNames = databaseProductNames;
    }

    public boolean isUseSqlStateForTranslation() {
        return this.useSqlStateForTranslation;
    }

    public void setUseSqlStateForTranslation(boolean useSqlStateForTranslation) {
        this.useSqlStateForTranslation = useSqlStateForTranslation;
    }

    public String[] getBadSqlGrammarCodes() {
        return this.badSqlGrammarCodes;
    }

    public void setBadSqlGrammarCodes(String[] badSqlGrammarCodes) {
        this.badSqlGrammarCodes = badSqlGrammarCodes;
    }

    public String[] getInvalidResultSetAccessCodes() {
        return this.invalidResultSetAccessCodes;
    }

    public void setInvalidResultSetAccessCodes(String[] invalidResultSetAccessCodes) {
        this.invalidResultSetAccessCodes = invalidResultSetAccessCodes;
    }

    public String[] getDuplicateKeyCodes() {
        return this.duplicateKeyCodes;
    }

    public void setDuplicateKeyCodes(String[] duplicateKeyCodes) {
        this.duplicateKeyCodes = duplicateKeyCodes;
    }

    public String[] getDataIntegrityViolationCodes() {
        return this.dataIntegrityViolationCodes;
    }

    public void setDataIntegrityViolationCodes(String[] dataIntegrityViolationCodes) {
        this.dataIntegrityViolationCodes = dataIntegrityViolationCodes;
    }

    public String[] getPermissionDeniedCodes() {
        return this.permissionDeniedCodes;
    }

    public void setPermissionDeniedCodes(String[] permissionDeniedCodes) {
        this.permissionDeniedCodes = permissionDeniedCodes;
    }

    public String[] getDataAccessResourceFailureCodes() {
        return this.dataAccessResourceFailureCodes;
    }

    public void setDataAccessResourceFailureCodes(String[] dataAccessResourceFailureCodes) {
        this.dataAccessResourceFailureCodes = dataAccessResourceFailureCodes;
    }

    public String[] getTransientDataAccessResourceCodes() {
        return this.transientDataAccessResourceCodes;
    }

    public void setTransientDataAccessResourceCodes(String[] transientDataAccessResourceCodes) {
        this.transientDataAccessResourceCodes = transientDataAccessResourceCodes;
    }

    public String[] getCannotAcquireLockCodes() {
        return this.cannotAcquireLockCodes;
    }

    public void setCannotAcquireLockCodes(String[] cannotAcquireLockCodes) {
        this.cannotAcquireLockCodes = cannotAcquireLockCodes;
    }

    public String[] getDeadlockLoserCodes() {
        return this.deadlockLoserCodes;
    }

    public void setDeadlockLoserCodes(String[] deadlockLoserCodes) {
        this.deadlockLoserCodes = deadlockLoserCodes;
    }

    public String[] getCannotSerializeTransactionCodes() {
        return this.cannotSerializeTransactionCodes;
    }

    public void setCannotSerializeTransactionCodes(String[] cannotSerializeTransactionCodes) {
        this.cannotSerializeTransactionCodes = cannotSerializeTransactionCodes;
    }

    abstract void init();

    private static String[] parse(String codes) {
        return codes.split(",");
    }
}

