/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jfaster.mango.exception.jdbc.IncorrectResultSetColumnCountException;
import org.jfaster.mango.jdbc.JdbcUtils;
import org.jfaster.mango.jdbc.RowMapper;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<T> mappedClass;

    public SingleColumnRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException("incorrect column count, expected 1 but " + nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.mappedClass);
        return (T)result;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index, requiredType);
    }
}

