/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.exception.IncorrectReturnTypeException;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.ToStringHelper;

public class BatchUpdateOperator
extends AbstractOperator {
    protected Transformer transformer;
    private static final Map<Class, Transformer> TRANSFORMERS = new LinkedHashMap<Class, Transformer>();

    protected BatchUpdateOperator(ASTRootNode rootNode, MethodDescriptor md) {
        super(rootNode);
        this.transformer = TRANSFORMERS.get(md.getReturnRawType());
        if (this.transformer == null) {
            String expected = ToStringHelper.toString(TRANSFORMERS.keySet());
            throw new IncorrectReturnTypeException("the return type of batch update expected one of " + expected + " but " + md.getReturnRawType());
        }
    }

    @Override
    public Object execute(Object[] values) {
        Object firstValue = values[0];
        if (firstValue == null) {
            throw new NullPointerException("batchUpdate's parameter can't be null");
        }
        Iterables iterables = new Iterables(firstValue);
        if (iterables.isEmpty()) {
            throw new IllegalArgumentException("batchUpdate's parameter can't be empty");
        }
        HashMap<DataSource, Group> gorupMap = new HashMap<DataSource, Group>();
        int t = 0;
        for (Object obj : iterables) {
            InvocationContext context = this.invocationContextFactory.newInvocationContext(new Object[]{obj});
            this.group(context, gorupMap, t++);
        }
        int[] ints = this.executeDb(gorupMap, t);
        return this.transformer.transform(ints);
    }

    protected void group(InvocationContext context, Map<DataSource, Group> groupMap, int position) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        DataSource ds = this.dataSourceGenerator.getDataSource(context);
        Group group = groupMap.get(ds);
        if (group == null) {
            group = new Group();
            groupMap.put(ds, group);
        }
        this.rootNode.render(context);
        PreparedSql preparedSql = context.getPreparedSql();
        this.invocationInterceptorChain.intercept(preparedSql, context);
        String sql = preparedSql.getSql();
        Object[] args = preparedSql.getArgs().toArray();
        group.add(sql, args, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeDb(Map<DataSource, Group> groupMap, int batchNum) {
        int[] r = new int[batchNum];
        long now = System.nanoTime();
        int t = 0;
        try {
            for (Map.Entry<DataSource, Group> entry : groupMap.entrySet()) {
                DataSource ds = entry.getKey();
                List<String> sqls = entry.getValue().getSqls();
                List<Object[]> batchArgs = entry.getValue().getBatchArgs();
                List<Integer> positions = entry.getValue().getPositions();
                int[] ints = this.isUniqueSql(sqls) ? this.jdbcOperations.batchUpdate(ds, sqls.get(0), batchArgs) : this.jdbcOperations.batchUpdate(ds, sqls, batchArgs);
                for (int i = 0; i < ints.length; ++i) {
                    r[positions.get((int)i).intValue()] = ints[i];
                }
                ++t;
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (t == groupMap.entrySet().size()) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return r;
    }

    protected boolean isUniqueSql(List<String> sqls) {
        String sql = sqls.get(0);
        boolean r = true;
        for (int i = 1; i < sqls.size(); ++i) {
            if (sql.equals(sqls.get(i))) continue;
            r = false;
            break;
        }
        return r;
    }

    static {
        TRANSFORMERS.put(Void.TYPE, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(int[].class, IntArrayTransformer.INSTANCE);
        TRANSFORMERS.put(Void.class, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Integer[].class, IntegerArrayTransformer.INSTANCE);
    }

    static enum VoidTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            return null;
        }
    }

    static enum IntegerTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            int r = 0;
            for (int e : s) {
                r += e;
            }
            return r;
        }
    }

    static enum IntegerArrayTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            Integer[] r = new Integer[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = s[i];
            }
            return r;
        }
    }

    static enum IntArrayTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            return s;
        }
    }

    public static interface Transformer {
        public Object transform(int[] var1);
    }

    protected static class Group {
        private List<String> sqls = new LinkedList<String>();
        private List<Object[]> batchArgs = new LinkedList<Object[]>();
        private List<Integer> positions = new LinkedList<Integer>();

        protected Group() {
        }

        public void add(String sql, Object[] args, int position) {
            this.sqls.add(sql);
            this.batchArgs.add(args);
            this.positions.add(position);
        }

        public List<String> getSqls() {
            return this.sqls;
        }

        public List<Object[]> getBatchArgs() {
            return this.batchArgs;
        }

        public List<Integer> getPositions() {
            return this.positions;
        }
    }
}

